/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import java.util.logging.Logger;

public class VehicleTuning
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(VehicleTuning.class.getName());
    private float frictionSlip = 10.5f;
    private float maxSuspensionForce = 6000.0f;
    private float maxSuspensionTravelCm = 500.0f;
    private float suspensionCompression = 0.83f;
    private float suspensionDamping = 0.88f;
    private float suspensionStiffness = 5.88f;

    public VehicleTuning() {
        this.create();
    }

    public float getFrictionSlip() {
        return this.frictionSlip;
    }

    public float getMaxSuspensionForce() {
        return this.maxSuspensionForce;
    }

    public float getMaxSuspensionTravelCm() {
        return this.maxSuspensionTravelCm;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public void setFrictionSlip(float coeff) {
        this.frictionSlip = coeff;
        long tuningId = this.nativeId();
        VehicleTuning.setFrictionSlip(tuningId, coeff);
    }

    public void setMaxSuspensionForce(float maxForce) {
        this.maxSuspensionForce = maxForce;
        long tuningId = this.nativeId();
        VehicleTuning.setMaxSuspensionForce(tuningId, maxForce);
    }

    public void setMaxSuspensionTravelCm(float travelCm) {
        this.maxSuspensionTravelCm = travelCm;
        long tuningId = this.nativeId();
        VehicleTuning.setMaxSuspensionTravelCm(tuningId, travelCm);
    }

    public void setSuspensionCompression(float damping) {
        this.suspensionCompression = damping;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionCompression(tuningId, damping);
    }

    public void setSuspensionDamping(float damping) {
        this.suspensionDamping = damping;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionDamping(tuningId, damping);
    }

    public void setSuspensionStiffness(float stiffness) {
        this.suspensionStiffness = stiffness;
        long tuningId = this.nativeId();
        VehicleTuning.setSuspensionStiffness(tuningId, stiffness);
    }

    private void create() {
        long tuningId = VehicleTuning.createNative();
        this.setNativeId(tuningId);
        VehicleTuning.setFrictionSlip(tuningId, this.frictionSlip);
        VehicleTuning.setMaxSuspensionForce(tuningId, this.maxSuspensionForce);
        VehicleTuning.setMaxSuspensionTravelCm(tuningId, this.maxSuspensionTravelCm);
        VehicleTuning.setSuspensionCompression(tuningId, this.suspensionCompression);
        VehicleTuning.setSuspensionDamping(tuningId, this.suspensionDamping);
        VehicleTuning.setSuspensionStiffness(tuningId, this.suspensionStiffness);
    }

    private static void freeNativeObject(long tuningId) {
        assert (tuningId != 0L);
        VehicleTuning.finalizeNative(tuningId);
    }

    private static native long createNative();

    private static native void finalizeNative(long var0);

    private static native void setFrictionSlip(long var0, float var2);

    private static native void setMaxSuspensionForce(long var0, float var2);

    private static native void setMaxSuspensionTravelCm(long var0, float var2);

    private static native void setSuspensionCompression(long var0, float var2);

    private static native void setSuspensionDamping(long var0, float var2);

    private static native void setSuspensionStiffness(long var0, float var2);
}

