/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.objects.PhysicsSoftBody;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftBodyMaterial
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(SoftBodyMaterial.class.getName());

    public SoftBodyMaterial(PhysicsSoftBody body) {
        long softBodyId = body.nativeId();
        long materialId = SoftBodyMaterial.getMaterialId(softBodyId);
        super.setNativeIdNotTracked(materialId);
    }

    public float angularStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getAngularStiffnessFactor(materialId);
        return result;
    }

    public float linearStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getLinearStiffnessFactor(materialId);
        return result;
    }

    public void setAngularStiffness(float coefficient) {
        Validate.fraction(coefficient, "stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setAngularStiffnessFactor(materialId, coefficient);
    }

    public void setLinearStiffness(float coefficient) {
        Validate.fraction(coefficient, "stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setLinearStiffnessFactor(materialId, coefficient);
    }

    public void setVolumeStiffness(float coefficient) {
        Validate.fraction(coefficient, "stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setVolumeStiffnessFactor(materialId, coefficient);
    }

    public float volumeStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getVolumeStiffnessFactor(materialId);
        return result;
    }

    private static native float getAngularStiffnessFactor(long var0);

    private static native float getLinearStiffnessFactor(long var0);

    private static native long getMaterialId(long var0);

    private static native float getVolumeStiffnessFactor(long var0);

    private static native void setAngularStiffnessFactor(long var0, float var2);

    private static native void setLinearStiffnessFactor(long var0, float var2);

    private static native void setVolumeStiffnessFactor(long var0, float var2);
}

