/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.bullet.objects.infos.Aero;
import com.jme3.bullet.objects.infos.Sbcp;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftBodyConfig {
    public static final Logger logger = Logger.getLogger(SoftBodyConfig.class.getName());
    private PhysicsSoftBody body = null;

    public SoftBodyConfig(PhysicsSoftBody body) {
        assert (body != null);
        this.body = body;
    }

    public Aero aerodynamics() {
        long bodyId = this.body.nativeId();
        int ordinal = SoftBodyConfig.getAeroModel(bodyId);
        Aero result = Aero.values()[ordinal];
        return result;
    }

    public int clusterIterations() {
        long bodyId = this.body.nativeId();
        int result = SoftBodyConfig.getClusterIterations(bodyId);
        return result;
    }

    public int collisionFlags() {
        long bodyId = this.body.nativeId();
        int result = SoftBodyConfig.getCollisionsFlags(bodyId);
        return result;
    }

    public void copyAll(SoftBodyConfig source) {
        long destId = this.body.nativeId();
        long sourceId = source.body.nativeId();
        SoftBodyConfig.copyValues(destId, sourceId);
    }

    public int driftIterations() {
        long bodyId = this.body.nativeId();
        int result = SoftBodyConfig.getDriftIterations(bodyId);
        return result;
    }

    public float get(Sbcp parameter) {
        float result;
        Validate.nonNull((Object)parameter, "parameter");
        long bodyId = this.body.nativeId();
        switch (parameter) {
            case AnchorHardness: {
                result = SoftBodyConfig.getAnchorsHardness(bodyId);
                break;
            }
            case ClusterKineticHardness: {
                result = SoftBodyConfig.getClusterKineticHardness(bodyId);
                break;
            }
            case ClusterKineticSplit: {
                result = SoftBodyConfig.getClusterKineticImpulseSplitCoef(bodyId);
                break;
            }
            case ClusterRigidHardness: {
                result = SoftBodyConfig.getClusterRigidHardness(bodyId);
                break;
            }
            case ClusterRigidSplit: {
                result = SoftBodyConfig.getClusterRigidImpulseSplitCoef(bodyId);
                break;
            }
            case ClusterSoftHardness: {
                result = SoftBodyConfig.getClusterSoftHardness(bodyId);
                break;
            }
            case ClusterSoftSplit: {
                result = SoftBodyConfig.getClusterSoftImpulseSplitCoef(bodyId);
                break;
            }
            case Damping: {
                result = SoftBodyConfig.getDampingCoef(bodyId);
                break;
            }
            case Drag: {
                result = SoftBodyConfig.getDragCoef(bodyId);
                break;
            }
            case DynamicFriction: {
                result = SoftBodyConfig.getDynamicFrictionCoef(bodyId);
                break;
            }
            case KineticHardness: {
                result = SoftBodyConfig.getKineticContactsHardness(bodyId);
                break;
            }
            case Lift: {
                result = SoftBodyConfig.getLiftCoef(bodyId);
                break;
            }
            case MaxVolumeRatio: {
                result = SoftBodyConfig.getMaximumVolumeRatio(bodyId);
                break;
            }
            case PoseMatching: {
                result = SoftBodyConfig.getPoseMatchingCoef(bodyId);
                break;
            }
            case Pressure: {
                result = SoftBodyConfig.getPressureCoef(bodyId);
                break;
            }
            case RigidHardness: {
                result = SoftBodyConfig.getRigidContactsHardness(bodyId);
                break;
            }
            case SoftHardness: {
                result = SoftBodyConfig.getSoftContactsHardness(bodyId);
                break;
            }
            case TimeScale: {
                result = SoftBodyConfig.getTimeScale(bodyId);
                break;
            }
            case VelocityCorrection: {
                result = SoftBodyConfig.getVelocitiesCorrectionFactor(bodyId);
                break;
            }
            case VolumeConservation: {
                result = SoftBodyConfig.getVolumeConservationCoef(bodyId);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
        assert (parameter.canSet(result)) : result;
        return result;
    }

    public int positionIterations() {
        long bodyId = this.body.nativeId();
        int result = SoftBodyConfig.getPositionIterations(bodyId);
        return result;
    }

    public void set(Sbcp parameter, float desiredValue) {
        if (!parameter.canSet(desiredValue)) {
            String message = String.format("%s cannot be set to %f", new Object[]{parameter, Float.valueOf(desiredValue)});
            throw new IllegalArgumentException(message);
        }
        long bodyId = this.body.nativeId();
        switch (parameter) {
            case AnchorHardness: {
                SoftBodyConfig.setAnchorsHardness(bodyId, desiredValue);
                break;
            }
            case ClusterKineticHardness: {
                SoftBodyConfig.setClusterKineticHardness(bodyId, desiredValue);
                break;
            }
            case ClusterKineticSplit: {
                SoftBodyConfig.setClusterKineticImpulseSplitCoef(bodyId, desiredValue);
                break;
            }
            case ClusterRigidHardness: {
                SoftBodyConfig.setClusterRigidHardness(bodyId, desiredValue);
                break;
            }
            case ClusterRigidSplit: {
                SoftBodyConfig.setClusterRigidImpulseSplitCoef(bodyId, desiredValue);
                break;
            }
            case ClusterSoftHardness: {
                SoftBodyConfig.setClusterSoftHardness(bodyId, desiredValue);
                break;
            }
            case ClusterSoftSplit: {
                SoftBodyConfig.setClusterSoftImpulseSplitCoef(bodyId, desiredValue);
                break;
            }
            case Damping: {
                SoftBodyConfig.setDampingCoef(bodyId, desiredValue);
                break;
            }
            case Drag: {
                SoftBodyConfig.setDragCoef(bodyId, desiredValue);
                break;
            }
            case DynamicFriction: {
                SoftBodyConfig.setDynamicFrictionCoef(bodyId, desiredValue);
                break;
            }
            case Lift: {
                SoftBodyConfig.setLiftCoef(bodyId, desiredValue);
                break;
            }
            case KineticHardness: {
                SoftBodyConfig.setKineticContactsHardness(bodyId, desiredValue);
                break;
            }
            case MaxVolumeRatio: {
                SoftBodyConfig.setMaximumVolumeRatio(bodyId, desiredValue);
                break;
            }
            case PoseMatching: {
                SoftBodyConfig.setPoseMatchingCoef(bodyId, desiredValue);
                break;
            }
            case Pressure: {
                SoftBodyConfig.setPressureCoef(bodyId, desiredValue);
                break;
            }
            case SoftHardness: {
                SoftBodyConfig.setSoftContactsHardness(bodyId, desiredValue);
                break;
            }
            case RigidHardness: {
                SoftBodyConfig.setRigidContactsHardness(bodyId, desiredValue);
                break;
            }
            case TimeScale: {
                SoftBodyConfig.setTimeScale(bodyId, desiredValue);
                break;
            }
            case VelocityCorrection: {
                SoftBodyConfig.setVelocitiesCorrectionFactor(bodyId, desiredValue);
                break;
            }
            case VolumeConservation: {
                SoftBodyConfig.setVolumeConservationCoef(bodyId, desiredValue);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
    }

    public void setAerodynamics(Aero model) {
        long bodyId = this.body.nativeId();
        int ordinal = model.ordinal();
        SoftBodyConfig.setAeroModel(bodyId, ordinal);
    }

    public void setClusterIterations(int numIterations) {
        long bodyId = this.body.nativeId();
        SoftBodyConfig.setClusterIterations(bodyId, numIterations);
    }

    public void setCollisionFlags(int flag, int ... additionalFlags) {
        int combinedFlags = flag;
        for (int additionalFlag : additionalFlags) {
            combinedFlags |= additionalFlag;
        }
        long bodyId = this.body.nativeId();
        SoftBodyConfig.setCollisionsFlags(bodyId, combinedFlags);
    }

    public void setDriftIterations(int numIterations) {
        long bodyId = this.body.nativeId();
        SoftBodyConfig.setDriftIterations(bodyId, numIterations);
    }

    public void setPositionIterations(int numIterations) {
        long bodyId = this.body.nativeId();
        SoftBodyConfig.setPositionIterations(bodyId, numIterations);
    }

    public void setVelocityIterations(int numIterations) {
        long bodyId = this.body.nativeId();
        SoftBodyConfig.setVelocitiesIterations(bodyId, numIterations);
    }

    public int velocityIterations() {
        long bodyId = this.body.nativeId();
        int result = SoftBodyConfig.getVelocitiesIterations(bodyId);
        return result;
    }

    private static native void copyValues(long var0, long var2);

    private static native int getAeroModel(long var0);

    private static native float getAnchorsHardness(long var0);

    private static native int getClusterIterations(long var0);

    private static native float getClusterKineticHardness(long var0);

    private static native float getClusterKineticImpulseSplitCoef(long var0);

    private static native float getClusterRigidHardness(long var0);

    private static native float getClusterRigidImpulseSplitCoef(long var0);

    private static native float getClusterSoftHardness(long var0);

    private static native float getClusterSoftImpulseSplitCoef(long var0);

    private static native int getCollisionsFlags(long var0);

    private static native float getDampingCoef(long var0);

    private static native float getDragCoef(long var0);

    private static native int getDriftIterations(long var0);

    private static native float getDynamicFrictionCoef(long var0);

    private static native float getKineticContactsHardness(long var0);

    private static native float getLiftCoef(long var0);

    private static native float getMaximumVolumeRatio(long var0);

    private static native float getPoseMatchingCoef(long var0);

    private static native int getPositionIterations(long var0);

    private static native float getPressureCoef(long var0);

    private static native float getRigidContactsHardness(long var0);

    private static native float getSoftContactsHardness(long var0);

    private static native float getTimeScale(long var0);

    private static native float getVelocitiesCorrectionFactor(long var0);

    private static native int getVelocitiesIterations(long var0);

    private static native float getVolumeConservationCoef(long var0);

    private static native void setAeroModel(long var0, int var2);

    private static native void setAnchorsHardness(long var0, float var2);

    private static native void setClusterIterations(long var0, int var2);

    private static native void setClusterKineticHardness(long var0, float var2);

    private static native void setClusterKineticImpulseSplitCoef(long var0, float var2);

    private static native void setClusterRigidHardness(long var0, float var2);

    private static native void setClusterRigidImpulseSplitCoef(long var0, float var2);

    private static native void setClusterSoftHardness(long var0, float var2);

    private static native void setClusterSoftImpulseSplitCoef(long var0, float var2);

    private static native void setCollisionsFlags(long var0, int var2);

    private static native void setDampingCoef(long var0, float var2);

    private static native void setDragCoef(long var0, float var2);

    private static native void setDriftIterations(long var0, int var2);

    private static native void setDynamicFrictionCoef(long var0, float var2);

    private static native void setKineticContactsHardness(long var0, float var2);

    private static native void setLiftCoef(long var0, float var2);

    private static native void setMaximumVolumeRatio(long var0, float var2);

    private static native void setPoseMatchingCoef(long var0, float var2);

    private static native void setPositionIterations(long var0, int var2);

    private static native void setPressureCoef(long var0, float var2);

    private static native void setRigidContactsHardness(long var0, float var2);

    private static native void setSoftContactsHardness(long var0, float var2);

    private static native void setTimeScale(long var0, float var2);

    private static native void setVelocitiesCorrectionFactor(long var0, float var2);

    private static native void setVelocitiesIterations(long var0, int var2);

    private static native void setVolumeConservationCoef(long var0, float var2);
}

