/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Logger;

public class RigidBodySnapshot {
    public static final Logger logger = Logger.getLogger(RigidBodySnapshot.class.getName());
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private final boolean contactResponse;
    private final boolean protectGravity;
    private final float angularDamping;
    private final float angularSleepingThreshold;
    private final float ccdMotionThreshold;
    private final float ccdSweptSphereRadius;
    private Float contactDamping;
    private final float contactProcessingThreshold;
    private Float contactStiffness;
    private final float deactivationTime;
    private final float friction;
    private final float linearDamping;
    private final float linearSleepingThreshold;
    private final float restitution;
    private final float rollingFriction;
    private final float spinningFriction;
    private final int anisotropicFrictionModes;
    private final long[] ignoreList;
    private final Matrix3f rotationMatrix;
    private final Vec3d angularVelocity;
    private final Vec3d linearVelocity;
    private final Vec3d location;
    private final Vector3f angularFactor;
    private final Vector3f anisotropicFrictionComponents;
    private final Vector3f linearFactor;
    private final Vector3f totalAppliedForce;
    private final Vector3f totalAppliedTorque;

    public RigidBodySnapshot(PhysicsRigidBody body) {
        int flags = body.collisionFlags();
        boolean hasCsd = (flags & 0x80) != 0;
        this.contactResponse = body.isContactResponse();
        this.protectGravity = body.isGravityProtected();
        this.angularDamping = body.getAngularDamping();
        this.angularSleepingThreshold = body.getAngularSleepingThreshold();
        this.ccdMotionThreshold = body.getCcdMotionThreshold();
        this.ccdSweptSphereRadius = body.getCcdSweptSphereRadius();
        if (hasCsd) {
            this.contactDamping = Float.valueOf(body.getContactDamping());
        }
        this.contactProcessingThreshold = body.getContactProcessingThreshold();
        if (hasCsd) {
            this.contactStiffness = Float.valueOf(body.getContactStiffness());
        }
        this.deactivationTime = body.getDeactivationTime();
        this.friction = body.getFriction();
        this.linearDamping = body.getLinearDamping();
        this.linearSleepingThreshold = body.getLinearSleepingThreshold();
        this.restitution = body.getRestitution();
        this.rollingFriction = body.getRollingFriction();
        this.spinningFriction = body.getSpinningFriction();
        int afMode = 0;
        for (int bitPosition = 0; bitPosition < 2; ++bitPosition) {
            int bitMask = 1 << bitPosition;
            if (!body.hasAnisotropicFriction(bitMask)) continue;
            afMode |= bitMask;
        }
        this.anisotropicFrictionModes = afMode;
        this.ignoreList = body.listIgnoredIds();
        this.rotationMatrix = body.getPhysicsRotationMatrix(null);
        if (body.isDynamic()) {
            this.angularVelocity = body.getAngularVelocityDp(null);
            this.linearVelocity = body.getLinearVelocityDp(null);
        } else {
            this.angularVelocity = new Vec3d();
            this.linearVelocity = new Vec3d();
        }
        this.location = body.getPhysicsLocationDp(null);
        this.anisotropicFrictionComponents = body.getAnisotropicFriction(null);
        this.angularFactor = body.getAngularFactor(null);
        this.linearFactor = body.getLinearFactor(null);
        this.totalAppliedForce = body.totalAppliedForce(null);
        this.totalAppliedTorque = body.totalAppliedTorque(null);
    }

    public void applyTo(PhysicsRigidBody body) {
        body.setContactResponse(this.contactResponse);
        body.setProtectGravity(this.protectGravity);
        body.setAngularDamping(this.angularDamping);
        body.setAngularSleepingThreshold(this.angularSleepingThreshold);
        body.setCcdMotionThreshold(this.ccdMotionThreshold);
        body.setCcdSweptSphereRadius(this.ccdSweptSphereRadius);
        if (this.contactDamping != null) {
            body.setContactDamping(this.contactDamping.floatValue());
        }
        body.setContactProcessingThreshold(this.contactProcessingThreshold);
        if (this.contactStiffness != null) {
            body.setContactStiffness(this.contactStiffness.floatValue());
        }
        body.setFriction(this.friction);
        body.setLinearDamping(this.linearDamping);
        body.setLinearSleepingThreshold(this.linearSleepingThreshold);
        body.setRestitution(this.restitution);
        body.setRollingFriction(this.rollingFriction);
        body.setSpinningFriction(this.spinningFriction);
        body.setAnisotropicFriction(this.anisotropicFrictionComponents, this.anisotropicFrictionModes);
        body.setIgnoreList(this.ignoreList);
        body.setPhysicsRotation(this.rotationMatrix);
        body.setPhysicsLocationDp(this.location);
        body.clearForces();
        body.setLinearFactor(scaleIdentity);
        body.applyCentralForce(this.totalAppliedForce);
        body.setLinearFactor(this.linearFactor);
        body.setAngularFactor(scaleIdentity);
        body.applyTorque(this.totalAppliedTorque);
        body.setAngularFactor(this.angularFactor);
        if (body.isDynamic()) {
            body.setAngularVelocityDp(this.angularVelocity);
            body.setLinearVelocityDp(this.linearVelocity);
        }
        body.setDeactivationTime(this.deactivationTime);
    }
}

