/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import java.util.ArrayList;
import java.util.logging.Logger;

public final class ConfigFlag {
    public static final int SDF_RS = 1;
    public static final int CL_RS = 2;
    public static final int SDF_RD = 4;
    public static final int VF_SS = 16;
    public static final int CL_SS = 32;
    public static final int CL_SELF = 64;
    public static final int VF_DD = 128;
    public static final int SDF_RDF = 256;
    public static final int SDF_MDF = 512;
    public static final int SDF_RDN = 1024;
    public static final Logger logger = Logger.getLogger(ConfigFlag.class.getName());

    private ConfigFlag() {
    }

    public static String describe(int flags) {
        ArrayList<String> flagList = new ArrayList<String>(5);
        if ((flags & 1) != 0) {
            flagList.add("SDF_RS");
        }
        if ((flags & 2) != 0) {
            flagList.add("CL_RS");
        }
        if ((flags & 4) != 0) {
            flagList.add("SDF_RD");
        }
        if ((flags & 0x10) != 0) {
            flagList.add("VF_SS");
        }
        if ((flags & 0x20) != 0) {
            flagList.add("CL_SS");
        }
        if ((flags & 0x40) != 0) {
            flagList.add("CL_SELF");
        }
        if ((flags & 0x80) != 0) {
            flagList.add("VF_DD");
        }
        if ((flags & 0x100) != 0) {
            flagList.add("SDF_RDF");
        }
        if ((flags & 0x200) != 0) {
            flagList.add("SDF_MDF");
        }
        if ((flags & 0x400) != 0) {
            flagList.add("SDF_RDN");
        }
        StringBuilder result = new StringBuilder(60);
        boolean addSeparators = false;
        for (String flagName : flagList) {
            if (addSeparators) {
                result.append(',');
            } else {
                addSeparators = true;
            }
            result.append(flagName);
        }
        return result.toString();
    }
}

