/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.objects.infos.VehicleTuning;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class VehicleWheel {
    public static final Logger logger = Logger.getLogger(VehicleWheel.class.getName());
    private boolean applyLocal = false;
    private boolean isFront;
    private float radius = 0.5f;
    private float restLength = 1.0f;
    private float rollInfluence = 1.0f;
    private int wheelIndex = 0;
    private long vehicleId = 0L;
    private final Matrix3f tmpMatrix = new Matrix3f();
    private final Quaternion wheelWorldRotation = new Quaternion();
    private final Vector3f axisDirection = new Vector3f();
    private final Vector3f location = new Vector3f();
    private final Vector3f suspensionDirection = new Vector3f();
    private final Vector3f wheelWorldLocation = new Vector3f();
    private final VehicleTuning tuning = new VehicleTuning();

    public VehicleWheel(Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        Validate.positive(radius, "radius");
        this.location.set(location);
        this.suspensionDirection.set(direction);
        this.axisDirection.set(axle);
        this.isFront = frontWheel;
        this.restLength = restLength;
        this.radius = radius;
    }

    boolean checkCopies() {
        boolean result;
        boolean nativeIsFront = VehicleWheel.isFront(this.vehicleId, this.wheelIndex);
        boolean bl = result = nativeIsFront == this.isFront;
        if (result) {
            float nativeRadius = VehicleWheel.getRadius(this.vehicleId, this.wheelIndex);
            boolean bl2 = result = nativeRadius == this.radius;
        }
        if (result) {
            float nativeRestLength = VehicleWheel.getRestLength(this.vehicleId, this.wheelIndex);
            boolean bl3 = result = nativeRestLength == this.restLength;
        }
        if (result) {
            float nativeRollInfluence = VehicleWheel.getRollInfluence(this.vehicleId, this.wheelIndex);
            result = nativeRollInfluence == this.rollInfluence;
        }
        return result;
    }

    public Vector3f getAxle(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.axisDirection.clone() : storeResult.set(this.axisDirection);
        return result;
    }

    public float getBrake() {
        float result = VehicleWheel.getBrake(this.vehicleId, this.wheelIndex);
        return result;
    }

    public Vector3f getCollisionLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        VehicleWheel.getCollisionLocation(this.vehicleId, this.wheelIndex, result);
        return result;
    }

    public Vector3f getCollisionNormal(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        VehicleWheel.getCollisionNormal(this.vehicleId, this.wheelIndex, result);
        return result;
    }

    public float getDeltaRotation() {
        return VehicleWheel.getDeltaRotation(this.vehicleId, this.wheelIndex);
    }

    public Vector3f getDirection(Vector3f storeResult) {
        if (storeResult == null) {
            return this.suspensionDirection.clone();
        }
        return storeResult.set(this.suspensionDirection);
    }

    public float getEngineForce() {
        float result = VehicleWheel.getEngineForce(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getFrictionSlip() {
        float result = this.tuning.getFrictionSlip();
        return result;
    }

    public int getIndex() {
        return this.wheelIndex;
    }

    public Vector3f getLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.location.clone() : storeResult.set(this.location);
        return result;
    }

    public float getMaxSuspensionForce() {
        float result = this.tuning.getMaxSuspensionForce();
        return result;
    }

    public float getMaxSuspensionTravelCm() {
        float result = this.tuning.getMaxSuspensionTravelCm();
        return result;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getRestLength() {
        return this.restLength;
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public float getRotationAngle() {
        float result = VehicleWheel.getRotationAngle(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSkidInfo() {
        float result = VehicleWheel.getSkidInfo(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSteerAngle() {
        float result = VehicleWheel.getSteerAngle(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSuspensionLength() {
        float result = VehicleWheel.getSuspensionLength(this.vehicleId, this.wheelIndex);
        return result;
    }

    public float getSuspensionStiffness() {
        float result = this.tuning.getSuspensionStiffness();
        return result;
    }

    public float getWheelsDampingCompression() {
        float result = this.tuning.getSuspensionCompression();
        return result;
    }

    public float getWheelsDampingRelaxation() {
        float result = this.tuning.getSuspensionDamping();
        return result;
    }

    public Vector3f getWheelWorldLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.wheelWorldLocation.clone() : storeResult.set(this.wheelWorldLocation);
        return result;
    }

    public Quaternion getWheelWorldRotation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? this.wheelWorldRotation.clone() : storeResult.set(this.wheelWorldRotation);
        return result;
    }

    public boolean isApplyLocal() {
        return this.applyLocal;
    }

    public boolean isFrontWheel() {
        return this.isFront;
    }

    public void setApplyLocal(boolean applyLocal) {
        this.applyLocal = applyLocal;
    }

    public void setFrictionSlip(float coeff) {
        this.tuning.setFrictionSlip(coeff);
        this.applyInfo();
    }

    public void setFrontWheel(boolean frontWheel) {
        this.isFront = frontWheel;
        this.applyInfo();
    }

    public void setMaxSuspensionForce(float maxForce) {
        this.tuning.setMaxSuspensionForce(maxForce);
        this.applyInfo();
    }

    public void setMaxSuspensionTravelCm(float travelCm) {
        this.tuning.setMaxSuspensionTravelCm(travelCm);
        this.applyInfo();
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.applyInfo();
    }

    public void setRestLength(float restLength) {
        this.restLength = restLength;
        this.applyInfo();
    }

    public void setRollInfluence(float rollInfluence) {
        this.rollInfluence = rollInfluence;
        this.applyInfo();
    }

    public void setRotationAngle(float angle) {
        VehicleWheel.setRotationAngle(this.vehicleId, this.wheelIndex, angle);
    }

    public void setSuspensionLength(float length) {
        VehicleWheel.setSuspensionLength(this.vehicleId, this.wheelIndex, length);
    }

    public void setSuspensionStiffness(float stiffness) {
        this.tuning.setSuspensionStiffness(stiffness);
        this.applyInfo();
    }

    public void setVehicleId(long vehicleId, int wheelIndex) {
        Validate.nonZero(vehicleId, "vehicle ID");
        Validate.nonNegative(wheelIndex, "wheel index");
        this.vehicleId = vehicleId;
        this.wheelIndex = wheelIndex;
        this.applyInfo();
    }

    public void setWheelsDampingCompression(float damping) {
        this.tuning.setSuspensionCompression(damping);
        this.applyInfo();
    }

    public void setWheelsDampingRelaxation(float wheelsDampingRelaxation) {
        this.tuning.setSuspensionDamping(wheelsDampingRelaxation);
        this.applyInfo();
    }

    public void updatePhysicsState() {
        VehicleWheel.getWheelLocation(this.vehicleId, this.wheelIndex, this.wheelWorldLocation);
        VehicleWheel.getWheelRotation(this.vehicleId, this.wheelIndex, this.tmpMatrix);
        this.wheelWorldRotation.fromRotationMatrix(this.tmpMatrix);
    }

    private void applyInfo() {
        if (this.vehicleId != 0L) {
            VehicleWheel.applyInfo(this.vehicleId, this.wheelIndex, this.getSuspensionStiffness(), this.getWheelsDampingRelaxation(), this.getWheelsDampingCompression(), this.getFrictionSlip(), this.rollInfluence, this.getMaxSuspensionTravelCm(), this.getMaxSuspensionForce(), this.radius, this.isFront, this.restLength);
            assert (this.checkCopies());
        }
    }

    private static native void applyInfo(long var0, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, boolean var11, float var12);

    private static native float getBrake(long var0, int var2);

    private static native void getCollisionLocation(long var0, int var2, Vector3f var3);

    private static native void getCollisionNormal(long var0, int var2, Vector3f var3);

    private static native float getDeltaRotation(long var0, int var2);

    private static native float getEngineForce(long var0, int var2);

    private static native float getRadius(long var0, int var2);

    private static native float getRestLength(long var0, int var2);

    private static native float getRollInfluence(long var0, int var2);

    private static native float getRotationAngle(long var0, int var2);

    private static native float getSkidInfo(long var0, int var2);

    private static native float getSteerAngle(long var0, int var2);

    private static native float getSuspensionLength(long var0, int var2);

    private static native void getWheelLocation(long var0, int var2, Vector3f var3);

    private static native void getWheelRotation(long var0, int var2, Matrix3f var3);

    private static native boolean isFront(long var0, int var2);

    private static native void setRotationAngle(long var0, int var2, float var3);

    private static native void setSuspensionLength(long var0, int var2, float var3);
}

