/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.objects.infos.RigidBodySnapshot;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public class PhysicsRigidBody
extends PhysicsBody {
    public static final Logger logger2 = Logger.getLogger(PhysicsRigidBody.class.getName());
    private boolean kinematic = false;
    protected float mass = 1.0f;
    private final RigidBodyMotionState motionState = new RigidBodyMotionState();

    public PhysicsRigidBody(CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        super.setCollisionShape(shape);
        this.rebuildRigidBody();
        assert (this.isContactResponse());
        assert (!this.isInWorld());
        assert (!this.isKinematic());
        assert (!this.isStatic());
        assert (this.mass == 1.0f) : this.mass;
    }

    public PhysicsRigidBody(CollisionShape shape, float mass) {
        Validate.nonNull(shape, "shape");
        Validate.nonNegative(mass, "mass");
        this.mass = mass;
        super.setCollisionShape(shape);
        this.rebuildRigidBody();
        assert (this.isContactResponse());
        assert (!this.isInWorld());
        assert (!this.isKinematic());
    }

    public void activate() {
        this.activate(true);
        assert (this.isActive());
    }

    public void applyCentralForce(Vector3f force) {
        Validate.finite(force, "force");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyCentralForce(objectId, force);
        this.activate();
    }

    public void applyCentralImpulse(Vector3f impulse) {
        Validate.finite(impulse, "impulse");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyCentralImpulse(objectId, impulse);
        this.activate();
    }

    public void applyForce(Vector3f force, Vector3f offset) {
        Validate.finite(force, "force");
        Validate.finite(offset, "offset");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyForce(objectId, force, offset);
        this.activate();
    }

    public void applyImpulse(Vector3f impulse, Vector3f offset) {
        Validate.finite(impulse, "impulse");
        Validate.finite(offset, "offset");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyImpulse(objectId, impulse, offset);
        this.activate();
    }

    public void applyTorque(Vector3f torque) {
        Validate.finite(torque, "torque");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyTorque(objectId, torque);
        this.activate();
    }

    public void applyTorqueImpulse(Vector3f torqueImpulse) {
        Validate.finite(torqueImpulse, "torque impulse");
        long objectId = this.nativeId();
        PhysicsRigidBody.applyTorqueImpulse(objectId, torqueImpulse);
        this.activate();
    }

    public void clearForces() {
        long objectId = this.nativeId();
        PhysicsRigidBody.clearForces(objectId);
    }

    public float getAngularDamping() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getAngularDamping(objectId);
        assert (result >= 0.0f) : result;
        assert (result <= 1.0f) : result;
        return result;
    }

    public Vector3f getAngularFactor(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularFactor(objectId, result);
        return result;
    }

    public float getAngularSleepingThreshold() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getAngularSleepingThreshold(objectId);
        return result;
    }

    public Vector3f getAngularVelocity(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocity(objectId, result);
        return result;
    }

    public Vec3d getAngularVelocityDp(Vec3d storeResult) {
        assert (this.isDynamic());
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocityDp(objectId, result);
        return result;
    }

    public Vector3f getAngularVelocityLocal(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getAngularVelocity(objectId, result);
        Quaternion localToWorld = this.getPhysicsRotation(null);
        Quaternion worldToLocal = localToWorld.inverse();
        worldToLocal.mult(result, result);
        return result;
    }

    public Vec3d getGravityDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getGravityDp(objectId, result);
        return result;
    }

    public Vector3f getInverseInertiaLocal(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getInverseInertiaLocal(objectId, result);
        return result;
    }

    public Matrix3f getInverseInertiaWorld(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getInverseInertiaWorld(objectId, result);
        return result;
    }

    public float getLinearDamping() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getLinearDamping(objectId);
        assert (result >= 0.0f) : result;
        assert (result <= 1.0f) : result;
        return result;
    }

    public Vector3f getLinearFactor(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearFactor(objectId, result);
        return result;
    }

    public float getLinearSleepingThreshold() {
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getLinearSleepingThreshold(objectId);
        return result;
    }

    public Vector3f getLinearVelocity(Vector3f storeResult) {
        assert (this.isDynamic());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearVelocity(objectId, result);
        return result;
    }

    public Vec3d getLinearVelocityDp(Vec3d storeResult) {
        assert (this.isDynamic());
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getLinearVelocityDp(objectId, result);
        return result;
    }

    public RigidBodyMotionState getMotionState() {
        return this.motionState;
    }

    public float getSquaredSpeed() {
        assert (this.isDynamic());
        long objectId = this.nativeId();
        float result = PhysicsRigidBody.getSquaredSpeed(objectId);
        return result;
    }

    public boolean isDynamic() {
        boolean result = this.mass > 0.0f && !this.kinematic;
        return result;
    }

    public boolean isGravityProtected() {
        long objectId = this.nativeId();
        boolean result = !PhysicsRigidBody.getUseSpaceGravity(objectId);
        return result;
    }

    public final boolean isKinematic() {
        assert (this.checkKinematicFlag()) : this.kinematic;
        return this.kinematic;
    }

    public double kineticEnergy() {
        assert (this.isDynamic());
        double mv2 = this.mass * this.getSquaredSpeed();
        Vector3f vec = new Vector3f();
        this.getAngularVelocityLocal(vec);
        double xx = vec.x;
        double yy = vec.y;
        double zz = vec.z;
        Vector3f invI = this.getInverseInertiaLocal(null);
        double iw2 = xx * xx / (double)invI.x + yy * yy / (double)invI.y + zz * zz / (double)invI.z;
        double result = (mv2 + iw2) / 2.0;
        assert (result >= 0.0) : result;
        return result;
    }

    public double mechanicalEnergy() {
        assert (this.isDynamic());
        Vector3f gravity = this.getGravity(null);
        Vector3f location = this.getPhysicsLocation(null);
        double potentialEnergy = (double)(-this.mass) * MyVector3f.dot(gravity, location);
        double result = potentialEnergy + this.kineticEnergy();
        return result;
    }

    public void rebuildRigidBody() {
        long oldId = 0L;
        PhysicsSpace removedFrom = null;
        RigidBodySnapshot snapshot = null;
        if (this.hasAssignedNativeObject()) {
            oldId = this.nativeId();
            removedFrom = (PhysicsSpace)this.getCollisionSpace();
            if (removedFrom != null) {
                removedFrom.removeCollisionObject(this);
            }
            snapshot = new RigidBodySnapshot(this);
            logger2.log(Level.INFO, "Clearing {0}.", this);
            this.clearIgnoreList();
            this.unassignNativeObject();
        }
        this.preRebuild();
        CollisionShape shape = this.getCollisionShape();
        long objectId = PhysicsRigidBody.createRigidBody(this.mass, this.motionState.nativeId(), shape.nativeId());
        this.setNativeId(objectId);
        assert (PhysicsRigidBody.getInternalType(objectId) == 2) : PhysicsRigidBody.getInternalType(objectId);
        if (logger2.isLoggable(Level.INFO)) {
            if (oldId == 0L) {
                logger2.log(Level.INFO, "Created {0}.", Long.toHexString(objectId));
            } else {
                logger2.log(Level.INFO, "Substituted {0} for {1}.", new Object[]{Long.toHexString(objectId), Long.toHexString(oldId)});
            }
        }
        if (this.mass != 0.0f) {
            this.setKinematic(this.kinematic);
        }
        this.postRebuild();
        if (removedFrom != null) {
            removedFrom.addCollisionObject(this);
        }
        if (snapshot != null) {
            snapshot.applyTo(this);
        }
    }

    public void setAngularDamping(float angularDamping) {
        Validate.fraction(angularDamping, "angular damping");
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularDamping(objectId, angularDamping);
    }

    public void setAngularFactor(float factor) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularFactor(objectId, new Vector3f(factor, factor, factor));
    }

    public void setAngularFactor(Vector3f factor) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularFactor(objectId, factor);
    }

    public void setAngularSleepingThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularSleepingThreshold(objectId, threshold);
    }

    public void setAngularVelocity(Vector3f omega) {
        Validate.finite(omega, "omega");
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularVelocity(objectId, omega);
        this.activate();
    }

    public void setAngularVelocityDp(Vec3d omega) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setAngularVelocityDp(objectId, omega);
        this.activate();
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        Validate.nonNull(collisionShape, "collision shape");
        if (this.isDynamic()) {
            PhysicsRigidBody.validateDynamicShape(collisionShape);
        }
        super.setCollisionShape(collisionShape);
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            long shapeId = collisionShape.nativeId();
            PhysicsRigidBody.setCollisionShape(objectId, shapeId);
            PhysicsRigidBody.updateMassProps(objectId, shapeId, this.mass);
        } else {
            this.rebuildRigidBody();
        }
    }

    public void setContactResponse(boolean newState) {
        int flags = this.collisionFlags();
        flags = newState ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        long objectId = this.nativeId();
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
    }

    public void setDamping(float linearDamping, float angularDamping) {
        Validate.fraction(linearDamping, "linear damping");
        Validate.fraction(angularDamping, "angular damping");
        long objectId = this.nativeId();
        PhysicsRigidBody.setDamping(objectId, linearDamping, angularDamping);
    }

    public void setEnableSleep(boolean setting) {
        long objectId = this.nativeId();
        if (setting) {
            PhysicsRigidBody.setActivationState(objectId, 1);
        } else {
            PhysicsRigidBody.setActivationState(objectId, 4);
        }
    }

    public void setGravityDp(Vec3d acceleration) {
        Validate.nonNull(acceleration, "acceleration");
        if (!this.isInWorld() && !this.isGravityProtected()) {
            logger2.warning("The body isn't in any PhysicsSpace, and its gravity isn't protected. Unless protection is set, adding it to a PhysicsSpace will override its gravity.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setGravityDp(objectId, acceleration);
    }

    public void setInverseInertiaLocal(Vector3f inverseInertia) {
        Validate.nonNull(inverseInertia, "inverse inertia");
        long objectId = this.nativeId();
        PhysicsRigidBody.setInverseInertiaLocal(objectId, inverseInertia);
    }

    public void setKinematic(boolean kinematic) {
        if (this.mass == 0.0f) {
            throw new IllegalStateException("Cannot set/clear kinematic mode on a static body!");
        }
        assert (!this.isStatic());
        this.kinematic = kinematic;
        long objectId = this.nativeId();
        PhysicsRigidBody.setKinematic(objectId, kinematic);
        assert (this.isKinematic() == kinematic) : kinematic;
    }

    public void setLinearDamping(float linearDamping) {
        Validate.fraction(linearDamping, "linear damping");
        long objectId = this.nativeId();
        float angularDamping = this.getAngularDamping();
        PhysicsRigidBody.setDamping(objectId, linearDamping, angularDamping);
    }

    public void setLinearFactor(Vector3f factor) {
        Validate.nonNull(factor, "factor");
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearFactor(objectId, factor);
    }

    public void setLinearSleepingThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearSleepingThreshold(objectId, threshold);
    }

    public void setLinearVelocity(Vector3f velocity) {
        Validate.finite(velocity, "velocity");
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearVelocity(objectId, velocity);
        this.activate();
    }

    public void setLinearVelocityDp(Vec3d velocity) {
        Validate.nonNull(velocity, "velocity");
        long objectId = this.nativeId();
        PhysicsRigidBody.setLinearVelocityDp(objectId, velocity);
        this.activate();
    }

    public void setPhysicsLocationDp(Vec3d location) {
        Validate.nonNull(location, "location");
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsLocationDp(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f orientation) {
        Validate.nonNull(orientation, "rotation");
        if (this.getCollisionShape() instanceof HeightfieldCollisionShape && !orientation.isIdentity()) {
            throw new IllegalArgumentException("No rotation of heightfields.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotation(Quaternion orientation) {
        Validate.nonZero(orientation, "orientation");
        if (this.getCollisionShape() instanceof HeightfieldCollisionShape && !MyQuaternion.isRotationIdentity(orientation)) {
            throw new IllegalArgumentException("No rotation of heightfields.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotationDp(Matrix3d orientation) {
        Validate.nonNull(orientation, "orientation");
        if (this.getCollisionShape() instanceof HeightfieldCollisionShape && !orientation.isIdentity()) {
            throw new IllegalArgumentException("No rotation of heightfields.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotationDp(objectId, orientation);
    }

    public void setPhysicsRotationDp(Quatd orientation) {
        Validate.nonZero(orientation, "orientation");
        if (this.getCollisionShape() instanceof HeightfieldCollisionShape && !orientation.isRotationIdentity()) {
            throw new IllegalArgumentException("No rotation of heightfields.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsRotationDp(objectId, orientation);
    }

    public void setPhysicsScale(Vector3f newScale) {
        CollisionShape shape = this.getCollisionShape();
        Vector3f oldScale = shape.getScale(null);
        if (MyVector3f.ne(oldScale, newScale)) {
            shape.setScale(newScale);
            this.setCollisionShape(shape);
        }
    }

    public void setPhysicsTransform(Transform transform) {
        this.setPhysicsLocation(transform.getTranslation());
        this.setPhysicsRotation(transform.getRotation());
        this.setPhysicsScale(transform.getScale());
    }

    public void setProtectGravity(boolean newState) {
        long objectId = this.nativeId();
        PhysicsRigidBody.setUseSpaceGravity(objectId, !newState);
    }

    public void setSleepingThresholds(float linear, float angular) {
        Validate.nonNegative(linear, "linear threshold");
        Validate.nonNegative(angular, "angular threshold");
        long objectId = this.nativeId();
        PhysicsRigidBody.setSleepingThresholds(objectId, linear, angular);
    }

    public Vector3f totalAppliedForce(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getTotalForce(objectId, result);
        return result;
    }

    public Vector3f totalAppliedTorque(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getTotalTorque(objectId, result);
        return result;
    }

    protected void postRebuild() {
        int flags = this.collisionFlags();
        flags = this.mass == 0.0f ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        long objectId = this.nativeId();
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
        this.initUserPointer();
    }

    protected void preRebuild() {
    }

    @Override
    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsRigidBody.getGravity(objectId, result);
        return result;
    }

    @Override
    public float getMass() {
        assert (this.checkMass());
        return this.mass;
    }

    @Override
    public void setGravity(Vector3f acceleration) {
        Validate.nonNull(acceleration, "acceleration");
        if (!this.isInWorld() && !this.isGravityProtected()) {
            logger2.warning("The body isn't in any PhysicsSpace, and its gravity isn't protected. Unless protection is set, adding it to a PhysicsSpace will override its gravity.");
        }
        long objectId = this.nativeId();
        PhysicsRigidBody.setGravity(objectId, acceleration);
    }

    @Override
    public void setMass(float mass) {
        Validate.nonNegative(mass, "mass");
        CollisionShape shape = this.getCollisionShape();
        assert (shape != null);
        if (mass != 0.0f) {
            PhysicsRigidBody.validateDynamicShape(shape);
        }
        assert (this.hasAssignedNativeObject());
        if (mass == this.mass) {
            return;
        }
        if (this.mass == 0.0f) {
            this.mass = mass;
            this.rebuildRigidBody();
            return;
        }
        this.mass = mass;
        long objectId = this.nativeId();
        PhysicsRigidBody.updateMassProps(objectId, shape.nativeId(), mass);
        int flags = this.collisionFlags();
        flags = mass == 0.0f ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        PhysicsRigidBody.setCollisionFlags(objectId, flags);
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        Validate.finite(location, "location");
        long objectId = this.nativeId();
        PhysicsRigidBody.setPhysicsLocation(objectId, location);
    }

    private boolean checkMass() {
        long objectId = this.nativeId();
        float nativeMass = PhysicsRigidBody.getMass(objectId);
        boolean result = FastMath.approximateEquals(nativeMass, this.mass);
        return result;
    }

    private boolean checkKinematicFlag() {
        boolean nativeKinematicFlag;
        if (this.mass == 0.0f) {
            return true;
        }
        int flags = this.collisionFlags();
        boolean bl = nativeKinematicFlag = (flags & 2) != 0;
        return this.kinematic == nativeKinematicFlag;
    }

    private static void validateDynamicShape(CollisionShape shape) {
        assert (shape != null);
        if (shape.isNonMoving()) {
            throw new IllegalStateException("Dynamic rigid body can't have a non-moving shape!");
        }
    }

    private static native void applyCentralForce(long var0, Vector3f var2);

    private static native void applyCentralImpulse(long var0, Vector3f var2);

    private static native void applyForce(long var0, Vector3f var2, Vector3f var3);

    private static native void applyImpulse(long var0, Vector3f var2, Vector3f var3);

    private static native void applyTorque(long var0, Vector3f var2);

    private static native void applyTorqueImpulse(long var0, Vector3f var2);

    private static native void clearForces(long var0);

    private static native long createRigidBody(float var0, long var1, long var3);

    private static native float getAngularDamping(long var0);

    private static native void getAngularFactor(long var0, Vector3f var2);

    private static native float getAngularSleepingThreshold(long var0);

    private static native void getAngularVelocity(long var0, Vector3f var2);

    private static native void getAngularVelocityDp(long var0, Vec3d var2);

    private static native void getGravity(long var0, Vector3f var2);

    private static native void getGravityDp(long var0, Vec3d var2);

    private static native void getInverseInertiaLocal(long var0, Vector3f var2);

    private static native void getInverseInertiaWorld(long var0, Matrix3f var2);

    private static native float getLinearDamping(long var0);

    private static native void getLinearFactor(long var0, Vector3f var2);

    private static native float getLinearSleepingThreshold(long var0);

    private static native void getLinearVelocity(long var0, Vector3f var2);

    private static native void getLinearVelocityDp(long var0, Vec3d var2);

    private static native float getMass(long var0);

    private static native float getSquaredSpeed(long var0);

    private static native void getTotalForce(long var0, Vector3f var2);

    private static native void getTotalTorque(long var0, Vector3f var2);

    private static native boolean getUseSpaceGravity(long var0);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularFactor(long var0, Vector3f var2);

    private static native void setAngularSleepingThreshold(long var0, float var2);

    private static native void setAngularVelocity(long var0, Vector3f var2);

    private static native void setAngularVelocityDp(long var0, Vec3d var2);

    private static native void setCollisionShape(long var0, long var2);

    private static native void setDamping(long var0, float var2, float var3);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setGravityDp(long var0, Vec3d var2);

    private static native void setInverseInertiaLocal(long var0, Vector3f var2);

    private static native void setKinematic(long var0, boolean var2);

    private static native void setLinearFactor(long var0, Vector3f var2);

    private static native void setLinearSleepingThreshold(long var0, float var2);

    private static native void setLinearVelocity(long var0, Vector3f var2);

    private static native void setLinearVelocityDp(long var0, Vec3d var2);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsLocationDp(long var0, Vec3d var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);

    private static native void setPhysicsRotation(long var0, Quaternion var2);

    private static native void setPhysicsRotationDp(long var0, Matrix3d var2);

    private static native void setPhysicsRotationDp(long var0, Quatd var2);

    private static native void setSleepingThresholds(long var0, float var2, float var3);

    private static native void setUseSpaceGravity(long var0, boolean var2);

    private static native void updateMassProps(long var0, long var2, float var4);
}

