/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsGhostObject
extends PhysicsCollisionObject {
    public static final Logger logger2 = Logger.getLogger(PhysicsGhostObject.class.getName());
    private final List<PhysicsCollisionObject> overlappingObjects = new LinkedList<PhysicsCollisionObject>();

    public PhysicsGhostObject(CollisionShape shape) {
        super.setCollisionShape(shape);
        this.buildObject();
        assert (!this.isContactResponse());
    }

    public PhysicsCollisionObject getOverlapping(int index) {
        PhysicsCollisionObject result = this.overlappingObjects.get(index);
        return result;
    }

    public int getOverlappingCount() {
        long objectId = this.nativeId();
        int result = PhysicsGhostObject.getOverlappingCount(objectId);
        return result;
    }

    public List<PhysicsCollisionObject> getOverlappingObjects() {
        this.overlappingObjects.clear();
        long objectId = this.nativeId();
        this.getOverlappingObjects(objectId);
        return this.overlappingObjects;
    }

    public void setPhysicsLocation(Vector3f location) {
        Validate.finite(location, "location");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsLocation(objectId, location);
    }

    public void setPhysicsLocationDp(Vec3d location) {
        Validate.finite(location, "location");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsLocationDp(objectId, location);
    }

    public void setPhysicsRotation(Matrix3f orientation) {
        Validate.nonNull(orientation, "orientation");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotation(Quaternion orientation) {
        Validate.nonZero(orientation, "orientation");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotation(objectId, orientation);
    }

    public void setPhysicsRotationDp(Matrix3d orientation) {
        Validate.nonNull(orientation, "orientation");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotationDp(objectId, orientation);
    }

    public void setPhysicsRotationDp(Quatd orientation) {
        Validate.nonZero(orientation, "orientation");
        long objectId = this.nativeId();
        PhysicsGhostObject.setPhysicsRotationDp(objectId, orientation);
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        this.buildObject();
    }

    private void addOverlappingObject_native(PhysicsCollisionObject co) {
        this.overlappingObjects.add(co);
    }

    private void buildObject() {
        long objectId;
        if (!this.hasAssignedNativeObject()) {
            objectId = PhysicsGhostObject.createGhostObject();
            this.setNativeId(objectId);
            assert (PhysicsGhostObject.getInternalType(objectId) == 4) : PhysicsGhostObject.getInternalType(objectId);
            logger2.log(Level.FINE, "Created {0}.", this);
            PhysicsGhostObject.setGhostFlags(objectId);
            this.initUserPointer();
        }
        objectId = this.nativeId();
        CollisionShape shape = this.getCollisionShape();
        PhysicsGhostObject.attachCollisionShape(objectId, shape.nativeId());
    }

    private static native long createGhostObject();

    private static native int getOverlappingCount(long var0);

    private native void getOverlappingObjects(long var1);

    private static native void setGhostFlags(long var0);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsLocationDp(long var0, Vec3d var2);

    private static native void setPhysicsRotation(long var0, Matrix3f var2);

    private static native void setPhysicsRotation(long var0, Quaternion var2);

    private static native void setPhysicsRotationDp(long var0, Matrix3d var2);

    private static native void setPhysicsRotationDp(long var0, Quatd var2);
}

