/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

import com.jme3.bullet.NativePhysicsObject;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RotationalLimitMotor
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(RotationalLimitMotor.class.getName());

    public RotationalLimitMotor(long nativeId) {
        Validate.nonZero(nativeId, "native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public float getAccumulatedImpulse() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getAccumulatedImpulse(motorId);
        return result;
    }

    public float getAngle() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getCurrentPosition(motorId);
        return result;
    }

    public float getDamping() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getDamping(motorId);
        return result;
    }

    public float getERP() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getERP(motorId);
        return result;
    }

    public float getLimitSoftness() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getLimitSoftness(motorId);
        return result;
    }

    public float getLowerLimit() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getLoLimit(motorId);
        return result;
    }

    public float getMaxLimitForce() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getMaxLimitForce(motorId);
        return result;
    }

    public float getMaxMotorForce() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getMaxMotorForce(motorId);
        return result;
    }

    public float getNormalCFM() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getNormalCFM(motorId);
        return result;
    }

    public float getRestitution() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getBounce(motorId);
        return result;
    }

    public float getStopCFM() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getStopCFM(motorId);
        return result;
    }

    public float getTargetVelocity() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getTargetVelocity(motorId);
        return result;
    }

    public float getUpperLimit() {
        long motorId = this.nativeId();
        float result = RotationalLimitMotor.getHiLimit(motorId);
        return result;
    }

    public boolean isEnableMotor() {
        long motorId = this.nativeId();
        boolean result = RotationalLimitMotor.isEnableMotor(motorId);
        return result;
    }

    public void setAccumulatedImpulse(float accumulatedImpulse) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setAccumulatedImpulse(motorId, accumulatedImpulse);
    }

    public void setDamping(float damping) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setDamping(motorId, damping);
    }

    public void setEnableMotor(boolean enableMotor) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setEnableMotor(motorId, enableMotor);
    }

    public void setERP(float erp) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setERP(motorId, erp);
    }

    public void setLimitSoftness(float limitSoftness) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setLimitSoftness(motorId, limitSoftness);
    }

    public void setLowerLimit(float lowerLimit) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setLoLimit(motorId, lowerLimit);
    }

    public void setMaxLimitForce(float maxLimitForce) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setMaxLimitForce(motorId, maxLimitForce);
    }

    public void setMaxMotorForce(float maxMotorForce) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setMaxMotorForce(motorId, maxMotorForce);
    }

    public void setNormalCFM(float cfm) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setNormalCFM(motorId, cfm);
    }

    public void setRestitution(float restitution) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setBounce(motorId, restitution);
    }

    public void setStopCFM(float cfm) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setStopCFM(motorId, cfm);
    }

    public void setTargetVelocity(float targetVelocity) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setTargetVelocity(motorId, targetVelocity);
    }

    public void setUpperLimit(float upperLimit) {
        long motorId = this.nativeId();
        RotationalLimitMotor.setHiLimit(motorId, upperLimit);
    }

    private static native float getAccumulatedImpulse(long var0);

    private static native float getBounce(long var0);

    private static native float getCurrentPosition(long var0);

    private static native float getDamping(long var0);

    private static native float getERP(long var0);

    private static native float getHiLimit(long var0);

    private static native float getLimitSoftness(long var0);

    private static native float getLoLimit(long var0);

    private static native float getMaxLimitForce(long var0);

    private static native float getMaxMotorForce(long var0);

    private static native float getNormalCFM(long var0);

    private static native float getStopCFM(long var0);

    private static native float getTargetVelocity(long var0);

    private static native boolean isEnableMotor(long var0);

    private static native void setAccumulatedImpulse(long var0, float var2);

    private static native void setBounce(long var0, float var2);

    private static native void setDamping(long var0, float var2);

    private static native void setEnableMotor(long var0, boolean var2);

    private static native void setERP(long var0, float var2);

    private static native void setHiLimit(long var0, float var2);

    private static native void setLimitSoftness(long var0, float var2);

    private static native void setLoLimit(long var0, float var2);

    private static native void setMaxLimitForce(long var0, float var2);

    private static native void setMaxMotorForce(long var0, float var2);

    private static native void setNormalCFM(long var0, float var2);

    private static native void setStopCFM(long var0, float var2);

    private static native void setTargetVelocity(long var0, float var2);
}

