/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.joints.motors.MotorParam;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RotationMotor
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(RotationMotor.class.getName());

    public RotationMotor(long nativeId) {
        Validate.nonZero(nativeId, "native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public float get(MotorParam param) {
        float result;
        long motorId = this.nativeId();
        switch (param) {
            case Bounce: {
                result = RotationMotor.getBounce(motorId);
                break;
            }
            case Damping: {
                result = RotationMotor.getDamping(motorId);
                break;
            }
            case Equilibrium: {
                result = RotationMotor.getEquilibrium(motorId);
                break;
            }
            case LowerLimit: {
                result = RotationMotor.getLowerLimit(motorId);
                break;
            }
            case MaxMotorForce: {
                result = RotationMotor.getMaxMotorForce(motorId);
                break;
            }
            case ServoTarget: {
                result = RotationMotor.getServoTarget(motorId);
                break;
            }
            case Stiffness: {
                result = RotationMotor.getStiffness(motorId);
                break;
            }
            case TargetVelocity: {
                result = RotationMotor.getTargetVelocity(motorId);
                break;
            }
            case UpperLimit: {
                result = RotationMotor.getUpperLimit(motorId);
                break;
            }
            default: {
                int paramIndex = param.nativeIndex();
                result = RotationMotor.getParameter(motorId, paramIndex);
            }
        }
        return result;
    }

    public boolean isDampingLimited() {
        long motorId = this.nativeId();
        boolean result = RotationMotor.isDampingLimited(motorId);
        return result;
    }

    public boolean isMotorEnabled() {
        long motorId = this.nativeId();
        boolean result = RotationMotor.isMotorEnabled(motorId);
        return result;
    }

    public boolean isServoEnabled() {
        long motorId = this.nativeId();
        boolean result = RotationMotor.isServoEnabled(motorId);
        return result;
    }

    public boolean isSpringEnabled() {
        long motorId = this.nativeId();
        boolean result = RotationMotor.isSpringEnabled(motorId);
        return result;
    }

    public boolean isStiffnessLimited() {
        long motorId = this.nativeId();
        boolean result = RotationMotor.isStiffnessLimited(motorId);
        return result;
    }

    public void set(MotorParam param, float value) {
        long motorId = this.nativeId();
        switch (param) {
            case Bounce: {
                RotationMotor.setBounce(motorId, value);
                break;
            }
            case Damping: {
                RotationMotor.setDamping(motorId, value);
                break;
            }
            case Equilibrium: {
                RotationMotor.setEquilibrium(motorId, value);
                break;
            }
            case LowerLimit: {
                RotationMotor.setLowerLimit(motorId, value);
                break;
            }
            case MaxMotorForce: {
                RotationMotor.setMaxMotorForce(motorId, value);
                break;
            }
            case ServoTarget: {
                RotationMotor.setServoTarget(motorId, value);
                break;
            }
            case Stiffness: {
                RotationMotor.setStiffness(motorId, value);
                break;
            }
            case TargetVelocity: {
                RotationMotor.setTargetVelocity(motorId, value);
                break;
            }
            case UpperLimit: {
                RotationMotor.setUpperLimit(motorId, value);
                break;
            }
            default: {
                int paramIndex = param.nativeIndex();
                RotationMotor.setParameter(motorId, paramIndex, value);
            }
        }
    }

    public void setDampingLimited(boolean limitDamping) {
        long motorId = this.nativeId();
        RotationMotor.setDampingLimited(motorId, limitDamping);
    }

    public void setMotorEnabled(boolean enableFlag) {
        long motorId = this.nativeId();
        RotationMotor.setMotorEnabled(motorId, enableFlag);
    }

    public void setServoEnabled(boolean enableFlag) {
        long motorId = this.nativeId();
        RotationMotor.setServoEnabled(motorId, enableFlag);
    }

    public void setSpringEnabled(boolean enableFlag) {
        long motorId = this.nativeId();
        RotationMotor.setSpringEnabled(motorId, enableFlag);
    }

    public void setStiffnessLimited(boolean limitStiffness) {
        long motorId = this.nativeId();
        RotationMotor.setStiffnessLimited(motorId, limitStiffness);
    }

    private static native float getBounce(long var0);

    private static native float getDamping(long var0);

    private static native float getEquilibrium(long var0);

    private static native float getLowerLimit(long var0);

    private static native float getMaxMotorForce(long var0);

    private static native float getParameter(long var0, int var2);

    private static native float getServoTarget(long var0);

    private static native float getStiffness(long var0);

    private static native float getTargetVelocity(long var0);

    private static native float getUpperLimit(long var0);

    private static native boolean isDampingLimited(long var0);

    private static native boolean isMotorEnabled(long var0);

    private static native boolean isServoEnabled(long var0);

    private static native boolean isSpringEnabled(long var0);

    private static native boolean isStiffnessLimited(long var0);

    private static native void setBounce(long var0, float var2);

    private static native void setDamping(long var0, float var2);

    private static native void setDampingLimited(long var0, boolean var2);

    private static native void setEquilibrium(long var0, float var2);

    private static native void setLowerLimit(long var0, float var2);

    private static native void setMaxMotorForce(long var0, float var2);

    private static native void setMotorEnabled(long var0, boolean var2);

    private static native void setParameter(long var0, int var2, float var3);

    private static native void setServoEnabled(long var0, boolean var2);

    private static native void setServoTarget(long var0, float var2);

    private static native void setSpringEnabled(long var0, boolean var2);

    private static native void setStiffness(long var0, float var2);

    private static native void setStiffnessLimited(long var0, boolean var2);

    private static native void setTargetVelocity(long var0, float var2);

    private static native void setUpperLimit(long var0, float var2);
}

