/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints.motors;

public enum MotorParam {
    Bounce,
    Damping,
    Equilibrium,
    LowerLimit,
    MaxMotorForce,
    MotorCfm,
    MotorErp,
    ServoTarget,
    Stiffness,
    StopCfm,
    StopErp,
    TargetVelocity,
    UpperLimit;


    public boolean canSet(float value) {
        boolean result = this.minValue() <= value && value <= this.maxValue();
        return result;
    }

    public float defaultForRotationMotor() {
        float result;
        switch (this) {
            case UpperLimit: {
                result = -1.0f;
                break;
            }
            case Bounce: 
            case Damping: 
            case Equilibrium: 
            case MotorCfm: 
            case ServoTarget: 
            case Stiffness: 
            case StopCfm: 
            case TargetVelocity: {
                result = 0.0f;
                break;
            }
            case StopErp: {
                result = 0.2f;
                break;
            }
            case MotorErp: {
                result = 0.9f;
                break;
            }
            case LowerLimit: {
                result = 1.0f;
                break;
            }
            case MaxMotorForce: {
                result = 6.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
        return result;
    }

    public float defaultForTranslationMotor() {
        float result;
        switch (this) {
            case UpperLimit: 
            case Bounce: 
            case Damping: 
            case Equilibrium: 
            case MotorCfm: 
            case ServoTarget: 
            case Stiffness: 
            case StopCfm: 
            case TargetVelocity: 
            case LowerLimit: 
            case MaxMotorForce: {
                result = 0.0f;
                break;
            }
            case StopErp: {
                result = 0.2f;
                break;
            }
            case MotorErp: {
                result = 0.9f;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
        return result;
    }

    public float maxValue() {
        float result;
        switch (this) {
            case Bounce: 
            case MotorCfm: 
            case StopCfm: 
            case StopErp: 
            case MotorErp: {
                result = 1.0f;
                break;
            }
            case UpperLimit: 
            case Damping: 
            case Equilibrium: 
            case ServoTarget: 
            case Stiffness: 
            case TargetVelocity: 
            case LowerLimit: 
            case MaxMotorForce: {
                result = Float.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
        return result;
    }

    public float minValue() {
        float result;
        switch (this) {
            case UpperLimit: 
            case Equilibrium: 
            case ServoTarget: 
            case TargetVelocity: 
            case LowerLimit: {
                result = -3.4028235E38f;
                break;
            }
            case Bounce: 
            case Damping: 
            case MotorCfm: 
            case Stiffness: 
            case StopCfm: 
            case StopErp: 
            case MotorErp: 
            case MaxMotorForce: {
                result = 0.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toString());
            }
        }
        return result;
    }

    public int nativeIndex() {
        switch (this) {
            case MotorCfm: {
                return 3;
            }
            case MotorErp: {
                return 1;
            }
            case StopCfm: {
                return 4;
            }
            case StopErp: {
                return 2;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }
}

