/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;

public class SliderJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(SliderJoint.class.getName());
    private final boolean useLinearReferenceFrameA;
    private final Matrix3f rotA;
    private final Matrix3f rotB;

    public SliderJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.useLinearReferenceFrameA = linearReferenceFrame == JointEnd.A;
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, boolean useLinearReferenceFrameA) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public float getDampingDirAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingDirAng(constraintId);
        return result;
    }

    public float getDampingDirLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingDirLin(constraintId);
        return result;
    }

    public float getDampingLimAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingLimAng(constraintId);
        return result;
    }

    public float getDampingLimLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingLimLin(constraintId);
        return result;
    }

    public float getDampingOrthoAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingOrthoAng(constraintId);
        return result;
    }

    public float getDampingOrthoLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getDampingOrthoLin(constraintId);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                SliderJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                SliderJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getLowerAngLimit() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getLowerAngLimit(constraintId);
        return result;
    }

    public float getLowerLinLimit() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getLowerLinLimit(constraintId);
        return result;
    }

    public float getMaxAngMotorForce() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getMaxAngMotorForce(constraintId);
        return result;
    }

    public float getMaxLinMotorForce() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getMaxLinMotorForce(constraintId);
        return result;
    }

    public float getRestitutionDirAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionDirAng(constraintId);
        return result;
    }

    public float getRestitutionDirLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionDirLin(constraintId);
        return result;
    }

    public float getRestitutionLimAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionLimAng(constraintId);
        return result;
    }

    public float getRestitutionLimLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionLimLin(constraintId);
        return result;
    }

    public float getRestitutionOrthoAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionOrthoAng(constraintId);
        return result;
    }

    public float getRestitutionOrthoLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getRestitutionOrthoLin(constraintId);
        return result;
    }

    public float getSoftnessDirAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessDirAng(constraintId);
        return result;
    }

    public float getSoftnessDirLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessDirLin(constraintId);
        return result;
    }

    public float getSoftnessLimAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessLimAng(constraintId);
        return result;
    }

    public float getSoftnessLimLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessLimLin(constraintId);
        return result;
    }

    public float getSoftnessOrthoAng() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessOrthoAng(constraintId);
        return result;
    }

    public float getSoftnessOrthoLin() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getSoftnessOrthoLin(constraintId);
        return result;
    }

    public float getTargetAngMotorVelocity() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getTargetAngMotorVelocity(constraintId);
        return result;
    }

    public float getTargetLinMotorVelocity() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getTargetLinMotorVelocity(constraintId);
        return result;
    }

    public float getUpperAngLimit() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getUpperAngLimit(constraintId);
        return result;
    }

    public float getUpperLinLimit() {
        long constraintId = this.nativeId();
        float result = SliderJoint.getUpperLinLimit(constraintId);
        return result;
    }

    public boolean isPoweredAngMotor() {
        long constraintId = this.nativeId();
        boolean result = SliderJoint.isPoweredAngMotor(constraintId);
        return result;
    }

    public boolean isPoweredLinMotor() {
        long constraintId = this.nativeId();
        boolean result = SliderJoint.isPoweredLinMotor(constraintId);
        return result;
    }

    public void setDampingDirAng(float dampingDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingDirAng(constraintId, dampingDirAng);
    }

    public void setDampingDirLin(float dampingDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingDirLin(constraintId, dampingDirLin);
    }

    public void setDampingLimAng(float dampingLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingLimAng(constraintId, dampingLimAng);
    }

    public void setDampingLimLin(float dampingLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingLimLin(constraintId, dampingLimLin);
    }

    public void setDampingOrthoAng(float dampingOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingOrthoAng(constraintId, dampingOrthoAng);
    }

    public void setDampingOrthoLin(float dampingOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setDampingOrthoLin(constraintId, dampingOrthoLin);
    }

    public void setLowerAngLimit(float lowerAngLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setLowerAngLimit(constraintId, lowerAngLimit);
    }

    public void setLowerLinLimit(float lowerLinLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setLowerLinLimit(constraintId, lowerLinLimit);
    }

    public void setMaxAngMotorForce(float maxAngMotorForce) {
        long constraintId = this.nativeId();
        SliderJoint.setMaxAngMotorForce(constraintId, maxAngMotorForce);
    }

    public void setMaxLinMotorForce(float maxLinMotorForce) {
        long constraintId = this.nativeId();
        SliderJoint.setMaxLinMotorForce(constraintId, maxLinMotorForce);
    }

    public void setPoweredAngMotor(boolean poweredAngMotor) {
        long constraintId = this.nativeId();
        SliderJoint.setPoweredAngMotor(constraintId, poweredAngMotor);
    }

    public void setPoweredLinMotor(boolean poweredLinMotor) {
        long constraintId = this.nativeId();
        SliderJoint.setPoweredLinMotor(constraintId, poweredLinMotor);
    }

    public void setRestitutionDirAng(float restitutionDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionDirAng(constraintId, restitutionDirAng);
    }

    public void setRestitutionDirLin(float restitutionDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionDirLin(constraintId, restitutionDirLin);
    }

    public void setRestitutionLimAng(float restitutionLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionLimAng(constraintId, restitutionLimAng);
    }

    public void setRestitutionLimLin(float restitutionLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionLimLin(constraintId, restitutionLimLin);
    }

    public void setRestitutionOrthoAng(float restitutionOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionOrthoAng(constraintId, restitutionOrthoAng);
    }

    public void setRestitutionOrthoLin(float restitutionOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setRestitutionOrthoLin(constraintId, restitutionOrthoLin);
    }

    public void setSoftnessDirAng(float softnessDirAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessDirAng(constraintId, softnessDirAng);
    }

    public void setSoftnessDirLin(float softnessDirLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessDirLin(constraintId, softnessDirLin);
    }

    public void setSoftnessLimAng(float softnessLimAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessLimAng(constraintId, softnessLimAng);
    }

    public void setSoftnessLimLin(float softnessLimLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessLimLin(constraintId, softnessLimLin);
    }

    public void setSoftnessOrthoAng(float softnessOrthoAng) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessOrthoAng(constraintId, softnessOrthoAng);
    }

    public void setSoftnessOrthoLin(float softnessOrthoLin) {
        long constraintId = this.nativeId();
        SliderJoint.setSoftnessOrthoLin(constraintId, softnessOrthoLin);
    }

    public void setTargetAngMotorVelocity(float targetAngMotorVelocity) {
        long constraintId = this.nativeId();
        SliderJoint.setTargetAngMotorVelocity(constraintId, targetAngMotorVelocity);
    }

    public void setTargetLinMotorVelocity(float targetLinMotorVelocity) {
        long constraintId = this.nativeId();
        SliderJoint.setTargetLinMotorVelocity(constraintId, targetLinMotorVelocity);
    }

    public void setUpperAngLimit(float upperAngLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setUpperAngLimit(constraintId, upperAngLimit);
    }

    public void setUpperLinLimit(float upperLinLimit) {
        long constraintId = this.nativeId();
        SliderJoint.setUpperLinLimit(constraintId, upperLinLimit);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        if (a == null) {
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Vector3f offset = this.pivotA.subtract(this.pivotB);
            b.setPhysicsLocation(offset);
            constraintId = SliderJoint.createJoint1(bId, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
            b.setPhysicsLocation(saveLocation);
        } else {
            long aId = a.nativeId();
            constraintId = SliderJoint.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        }
        assert (SliderJoint.getConstraintType(constraintId) == 7);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7, boolean var8);

    private static native long createJoint1(long var0, Vector3f var2, Matrix3f var3, boolean var4);

    private static native float getDampingDirAng(long var0);

    private static native float getDampingDirLin(long var0);

    private static native float getDampingLimAng(long var0);

    private static native float getDampingLimLin(long var0);

    private static native float getDampingOrthoAng(long var0);

    private static native float getDampingOrthoLin(long var0);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native float getLowerAngLimit(long var0);

    private static native float getLowerLinLimit(long var0);

    private static native float getMaxAngMotorForce(long var0);

    private static native float getMaxLinMotorForce(long var0);

    private static native float getRestitutionDirAng(long var0);

    private static native float getRestitutionDirLin(long var0);

    private static native float getRestitutionLimAng(long var0);

    private static native float getRestitutionLimLin(long var0);

    private static native float getRestitutionOrthoAng(long var0);

    private static native float getRestitutionOrthoLin(long var0);

    private static native float getSoftnessDirAng(long var0);

    private static native float getSoftnessDirLin(long var0);

    private static native float getSoftnessLimAng(long var0);

    private static native float getSoftnessLimLin(long var0);

    private static native float getSoftnessOrthoAng(long var0);

    private static native float getSoftnessOrthoLin(long var0);

    private static native float getTargetAngMotorVelocity(long var0);

    private static native float getTargetLinMotorVelocity(long var0);

    private static native float getUpperAngLimit(long var0);

    private static native float getUpperLinLimit(long var0);

    private static native boolean isPoweredAngMotor(long var0);

    private static native boolean isPoweredLinMotor(long var0);

    private static native void setDampingDirAng(long var0, float var2);

    private static native void setDampingDirLin(long var0, float var2);

    private static native void setDampingLimAng(long var0, float var2);

    private static native void setDampingLimLin(long var0, float var2);

    private static native void setDampingOrthoAng(long var0, float var2);

    private static native void setDampingOrthoLin(long var0, float var2);

    private static native void setLowerAngLimit(long var0, float var2);

    private static native void setLowerLinLimit(long var0, float var2);

    private static native void setMaxAngMotorForce(long var0, float var2);

    private static native void setMaxLinMotorForce(long var0, float var2);

    private static native void setPoweredAngMotor(long var0, boolean var2);

    private static native void setPoweredLinMotor(long var0, boolean var2);

    private static native void setRestitutionDirAng(long var0, float var2);

    private static native void setRestitutionDirLin(long var0, float var2);

    private static native void setRestitutionLimAng(long var0, float var2);

    private static native void setRestitutionLimLin(long var0, float var2);

    private static native void setRestitutionOrthoAng(long var0, float var2);

    private static native void setRestitutionOrthoLin(long var0, float var2);

    private static native void setSoftnessDirAng(long var0, float var2);

    private static native void setSoftnessDirLin(long var0, float var2);

    private static native void setSoftnessLimAng(long var0, float var2);

    private static native void setSoftnessLimLin(long var0, float var2);

    private static native void setSoftnessOrthoAng(long var0, float var2);

    private static native void setSoftnessOrthoLin(long var0, float var2);

    private static native void setTargetAngMotorVelocity(long var0, float var2);

    private static native void setTargetLinMotorVelocity(long var0, float var2);

    private static native void setUpperAngLimit(long var0, float var2);

    private static native void setUpperLinLimit(long var0, float var2);
}

