/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SixDofSpringJoint
extends SixDofJoint {
    public static final Logger logger3 = Logger.getLogger(SixDofSpringJoint.class.getName());

    public SixDofSpringJoint(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, JointEnd linearReferenceFrame) {
        super(rigidBodyB, pivotInB, pivotInWorld, rotInB, rotInWorld, linearReferenceFrame);
    }

    public SixDofSpringJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, boolean useLinearReferenceFrameA) {
        super(rigidBodyA, rigidBodyB, pivotInA, pivotInB, rotInA, rotInB, useLinearReferenceFrameA);
    }

    public void enableSpring(int dofIndex, boolean onOff) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.enableSpring(constraintId, dofIndex, onOff);
    }

    public float getDamping(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getDamping(constraintId, dofIndex);
        return result;
    }

    public float getEquilibriumPoint(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getEquilibriumPoint(constraintId, dofIndex);
        return result;
    }

    public float getStiffness(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        float result = SixDofSpringJoint.getStiffness(constraintId, dofIndex);
        return result;
    }

    public boolean isSpringEnabled(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        boolean result = SixDofSpringJoint.isSpringEnabled(constraintId, dofIndex);
        return result;
    }

    public void setDamping(int dofIndex, float damping) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setDamping(constraintId, dofIndex, damping);
    }

    public void setEquilibriumPoint() {
        long constraintId = this.nativeId();
        SixDofSpringJoint.setEquilibriumPoint(constraintId);
    }

    public void setEquilibriumPoint(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setEquilibriumPoint(constraintId, dofIndex);
    }

    public void setStiffness(int dofIndex, float stiffness) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        SixDofSpringJoint.setStiffness(constraintId, dofIndex, stiffness);
    }

    @Override
    protected native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    @Override
    protected native long createJoint1(long var1, Vector3f var3, Matrix3f var4, boolean var5);

    private static native void enableSpring(long var0, int var2, boolean var3);

    private static native float getDamping(long var0, int var2);

    private static native float getEquilibriumPoint(long var0, int var2);

    private static native float getStiffness(long var0, int var2);

    private static native boolean isSpringEnabled(long var0, int var2);

    private static native void setDamping(long var0, int var2, float var3);

    private static native void setEquilibriumPoint(long var0);

    private static native void setEquilibriumPoint(long var0, int var2);

    private static native void setStiffness(long var0, int var2, float var3);
}

