/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Point2PointJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(Point2PointJoint.class.getName());

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA) {
        super(rigidBodyA, JointEnd.A, pivotInA);
        this.createJoint();
    }

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Vector3f pivotInWorld) {
        super(rigidBodyA, JointEnd.A, pivotInA, pivotInWorld);
        this.createJoint();
    }

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.createJoint();
    }

    public float getDamping() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getDamping(constraintId);
        return result;
    }

    public float getImpulseClamp() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getImpulseClamp(constraintId);
        return result;
    }

    public Vector3f getPivotInA(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        Point2PointJoint.getPivotInA(constraintId, result);
        return result;
    }

    public Vector3f getPivotInB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        Point2PointJoint.getPivotInB(constraintId, result);
        return result;
    }

    public float getTau() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getTau(constraintId);
        return result;
    }

    public void setDamping(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setDamping(constraintId, value);
    }

    public void setImpulseClamp(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setImpulseClamp(constraintId, value);
    }

    public void setTau(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setTau(constraintId, value);
    }

    @Override
    public void setPivotInA(Vector3f location) {
        Validate.nonNull(location, "location");
        long constraintId = this.nativeId();
        Point2PointJoint.setPivotInA(constraintId, location);
        super.setPivotInA(location);
    }

    @Override
    public void setPivotInB(Vector3f location) {
        Validate.nonNull(location, "location");
        long constraintId = this.nativeId();
        Point2PointJoint.setPivotInB(constraintId, location);
        if (this.pivotB != null) {
            super.setPivotInB(location);
        }
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            if (this.pivotB == null) {
                constraintId = Point2PointJoint.createJoint1(aId, this.pivotA);
            } else {
                Vector3f saveLocation = a.getPhysicsLocation(null);
                Transform localToWorld = new Transform();
                localToWorld.setTranslation(saveLocation);
                a.getPhysicsRotation(localToWorld.getRotation());
                Vector3f pivotAWorld = localToWorld.transformVector(this.pivotA, null);
                Vector3f worldOffset = this.pivotB.subtract(pivotAWorld);
                Vector3f tempLocation = saveLocation.add(worldOffset);
                a.setPhysicsLocation(tempLocation);
                constraintId = Point2PointJoint.createJoint1(aId, this.pivotA);
                a.setPhysicsLocation(saveLocation);
            }
        } else {
            assert (this.pivotB != null);
            long bId = b.nativeId();
            constraintId = Point2PointJoint.createJoint(aId, bId, this.pivotA, this.pivotB);
        }
        assert (Point2PointJoint.getConstraintType(constraintId) == 3);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5);

    private static native long createJoint1(long var0, Vector3f var2);

    private static native float getDamping(long var0);

    private static native float getImpulseClamp(long var0);

    private static native void getPivotInA(long var0, Vector3f var2);

    private static native void getPivotInB(long var0, Vector3f var2);

    private static native float getTau(long var0);

    private static native void setDamping(long var0, float var2);

    private static native void setImpulseClamp(long var0, float var2);

    private static native void setPivotInA(long var0, Vector3f var2);

    private static native void setPivotInB(long var0, Vector3f var2);

    private static native void setTau(long var0, float var2);
}

