/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationMotor;
import com.jme3.bullet.joints.motors.TranslationMotor;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class New6Dof
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(New6Dof.class.getName());
    private final Matrix3f rotA;
    private final Matrix3f rotB;
    private RotationMotor[] rotationMotor;
    private final RotationOrder rotationOrder;
    private TranslationMotor translationMotor;

    public New6Dof(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, RotationOrder rotationOrder) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.rotA = rotInWorld.clone();
        this.rotB = rotInB.clone();
        this.rotationOrder = rotationOrder;
        this.createConstraint();
    }

    public New6Dof(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, RotationOrder rotationOrder) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.rotationOrder = rotationOrder;
        this.createConstraint();
    }

    public Matrix3f calculatedBasisA(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedBasisA(constraintId, result);
        return result;
    }

    public Matrix3f calculatedBasisB(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedBasisB(constraintId, result);
        return result;
    }

    public Vector3f calculatedOriginA(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedOriginA(constraintId, result);
        return result;
    }

    public Vector3f calculatedOriginB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedOriginB(constraintId, result);
        return result;
    }

    public boolean checkRotationOrder() {
        long constraintId = this.nativeId();
        int rotOrder = New6Dof.getRotationOrder(constraintId);
        boolean result = rotOrder == this.rotationOrder.ordinal();
        return result;
    }

    public void enableSpring(int dofIndex, boolean onOff) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        New6Dof.enableSpring(constraintId, dofIndex, onOff);
    }

    public float get(MotorParam parameter, int dofIndex) {
        float result;
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.get(parameter);
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            Vector3f vector = motor.get(parameter, null);
            result = vector.get(dofIndex);
        }
        return result;
    }

    public Vector3f getAngles(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getAngles(constraintId, result);
        return result;
    }

    public Vector3f getAxis(int axisIndex, Vector3f storeResult) {
        Validate.axisIndex(axisIndex, "axis index");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getAxis(constraintId, axisIndex, result);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                New6Dof.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                New6Dof.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public Vector3f getPivotOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getPivotOffset(constraintId, result);
        return result;
    }

    public RotationMotor getRotationMotor(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        return this.rotationMotor[axisIndex];
    }

    public RotationOrder getRotationOrder() {
        this.checkRotationOrder();
        assert (this.rotationOrder != null);
        return this.rotationOrder;
    }

    public TranslationMotor getTranslationMotor() {
        return this.translationMotor;
    }

    public boolean isMotorEnabled(int dofIndex) {
        boolean result;
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isMotorEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isMotorEnabled(dofIndex);
        }
        return result;
    }

    public boolean isServoEnabled(int dofIndex) {
        boolean result;
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isServoEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isServoEnabled(dofIndex);
        }
        return result;
    }

    public boolean isSpringEnabled(int dofIndex) {
        boolean result;
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isSpringEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isSpringEnabled(dofIndex);
        }
        return result;
    }

    public static New6Dof newInstance(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInWorld, Quaternion rotInWorld, RotationOrder rotationOrder) {
        Validate.nonNull(rigidBodyA, "a");
        Validate.nonNull(rigidBodyB, "b");
        Validate.finite(pivotInWorld, "pivot location");
        Validate.nonZero(rotInWorld, "pivot orientation");
        Validate.nonNull((Object)rotationOrder, "rotation order");
        Transform tmpTransform = new Transform();
        rigidBodyA.getTransform(tmpTransform);
        tmpTransform.setScale(1.0f);
        tmpTransform = tmpTransform.invert();
        Transform p2a = new Transform(pivotInWorld, rotInWorld);
        p2a.combineWithParent(tmpTransform);
        Vector3f pivotInA = p2a.getTranslation();
        Matrix3f rotInA = p2a.getRotation().toRotationMatrix();
        rigidBodyB.getTransform(tmpTransform);
        tmpTransform.setScale(1.0f);
        tmpTransform = tmpTransform.invert();
        Transform p2b = new Transform(pivotInWorld, rotInWorld);
        p2b.combineWithParent(tmpTransform);
        Vector3f pivotInB = p2b.getTranslation();
        Matrix3f rotInB = p2b.getRotation().toRotationMatrix();
        New6Dof result = new New6Dof(rigidBodyA, rigidBodyB, pivotInA, pivotInB, rotInA, rotInB, rotationOrder);
        return result;
    }

    public void set(MotorParam parameter, int dofIndex, float value) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            motor.set(parameter, value);
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            Vector3f vector = motor.get(parameter, null);
            vector.set(dofIndex, value);
            motor.set(parameter, vector);
        }
    }

    public void setDamping(int dofIndex, float damping, boolean limitIfNeeded) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        New6Dof.setDamping(constraintId, dofIndex, damping, limitIfNeeded);
    }

    public void setEquilibriumPoint() {
        long constraintId = this.nativeId();
        New6Dof.setAllEquilibriumPointsToCurrent(constraintId);
    }

    public void setEquilibriumPoint(int dofIndex) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        New6Dof.setEquilibriumPointToCurrent(constraintId, dofIndex);
    }

    public void setEquilibriumPoint(int dofIndex, float value) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        New6Dof.setEquilibriumPoint(constraintId, dofIndex, value);
    }

    public void setRotationOrder(RotationOrder rotationOrder) {
        long constraintId = this.nativeId();
        int rotOrder = rotationOrder.ordinal();
        New6Dof.setRotationOrder(constraintId, rotOrder);
    }

    public void setStiffness(int dofIndex, float stiffness, boolean limitIfNeeded) {
        Validate.inRange(dofIndex, "DOF index", 0, 5);
        long constraintId = this.nativeId();
        New6Dof.setStiffness(constraintId, dofIndex, stiffness, limitIfNeeded);
    }

    @Override
    public void setPivotInA(Vector3f location) {
        Validate.nonNull(location, "location");
        long constraintId = this.nativeId();
        New6Dof.setPivotInA(constraintId, location);
        if (this.pivotA != null) {
            super.setPivotInA(location);
        }
    }

    @Override
    public void setPivotInB(Vector3f location) {
        Validate.nonNull(location, "location");
        long constraintId = this.nativeId();
        New6Dof.setPivotInB(constraintId, location);
        super.setPivotInB(location);
    }

    private void createConstraint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        int rotOrder = this.rotationOrder.ordinal();
        if (a == null) {
            Transform jInWorld = new Transform();
            jInWorld.getRotation().fromRotationMatrix(this.rotA);
            jInWorld.setTranslation(this.pivotA);
            Transform jInB = new Transform();
            jInB.getRotation().fromRotationMatrix(this.rotB);
            jInB.setTranslation(this.pivotB);
            Transform bToWorld = jInB.invert().combineWithParent(jInWorld);
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Quaternion saveRotation = b.getPhysicsRotation(null);
            b.setPhysicsLocation(bToWorld.getTranslation());
            b.setPhysicsRotation(bToWorld.getRotation());
            constraintId = New6Dof.createSingleEnded(bId, this.pivotB, this.rotB, rotOrder);
            b.setPhysicsLocation(saveLocation);
            b.setPhysicsRotation(saveRotation);
        } else {
            long aId = a.nativeId();
            constraintId = New6Dof.createDoubleEnded(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, rotOrder);
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Created {0} with A={1} B={2}", new Object[]{Long.toHexString(constraintId), Long.toHexString(aId), Long.toHexString(bId)});
            }
        }
        assert (New6Dof.getConstraintType(constraintId) == 12);
        this.setNativeId(constraintId);
        this.gatherMotors();
    }

    private void gatherMotors() {
        assert (this.rotationMotor == null);
        assert (this.translationMotor == null);
        long constraintId = this.nativeId();
        this.rotationMotor = new RotationMotor[3];
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            long motorId = New6Dof.getRotationalMotor(constraintId, axisIndex);
            this.rotationMotor[axisIndex] = new RotationMotor(motorId);
        }
        long motorId = New6Dof.getTranslationalMotor(constraintId);
        this.translationMotor = new TranslationMotor(motorId);
    }

    private static native long createDoubleEnded(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7, int var8);

    private static native long createSingleEnded(long var0, Vector3f var2, Matrix3f var3, int var4);

    private static native void enableSpring(long var0, int var2, boolean var3);

    private static native void getAngles(long var0, Vector3f var2);

    private static native void getAxis(long var0, int var2, Vector3f var3);

    private static native void getCalculatedBasisA(long var0, Matrix3f var2);

    private static native void getCalculatedBasisB(long var0, Matrix3f var2);

    private static native void getCalculatedOriginA(long var0, Vector3f var2);

    private static native void getCalculatedOriginB(long var0, Vector3f var2);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void getPivotOffset(long var0, Vector3f var2);

    private static native long getRotationalMotor(long var0, int var2);

    private static native int getRotationOrder(long var0);

    private static native long getTranslationalMotor(long var0);

    private static native void setAllEquilibriumPointsToCurrent(long var0);

    private static native void setDamping(long var0, int var2, float var3, boolean var4);

    private static native void setEquilibriumPoint(long var0, int var2, float var3);

    private static native void setEquilibriumPointToCurrent(long var0, int var2);

    private static native void setPivotInA(long var0, Vector3f var2);

    private static native void setPivotInB(long var0, Vector3f var2);

    private static native void setRotationOrder(long var0, int var2);

    private static native void setStiffness(long var0, int var2, float var3, boolean var4);
}

