/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.math.MyVector3f;

public class HingeJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(HingeJoint.class.getName());
    private boolean angularOnly = false;
    private boolean useReferenceFrameA = false;
    private float biasFactor = 0.3f;
    private float limitSoftness = 0.9f;
    private float relaxationFactor = 1.0f;
    private final Vector3f axisA;
    private final Vector3f axisB;

    public HingeJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Vector3f pivotInWorld, Vector3f axisInA, Vector3f axisInWorld, JointEnd referenceFrame) {
        super(rigidBodyA, JointEnd.A, pivotInA, pivotInWorld);
        assert (axisInA.isUnitVector()) : axisInA;
        assert (axisInWorld.isUnitVector()) : axisInWorld;
        this.axisA = axisInA.clone();
        this.axisB = axisInWorld.clone();
        this.useReferenceFrameA = referenceFrame == JointEnd.A;
        this.createJoint();
        long constraintId = super.nativeId();
        HingeJoint.setAngularOnly(constraintId, this.angularOnly);
        float low = this.getLowerLimit();
        float high = this.getUpperLimit();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public HingeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Vector3f axisInA, Vector3f axisInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        assert (axisInA.isUnitVector()) : axisInA;
        assert (axisInB.isUnitVector()) : axisInB;
        this.axisA = axisInA.clone();
        this.axisB = axisInB.clone();
        this.createJoint();
        long constraintId = super.nativeId();
        HingeJoint.setAngularOnly(constraintId, this.angularOnly);
        float low = this.getLowerLimit();
        float high = this.getUpperLimit();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public void enableMotor(boolean enable, float targetVelocity, float maxMotorImpulse) {
        long constraintId = this.nativeId();
        HingeJoint.enableMotor(constraintId, enable, targetVelocity, maxMotorImpulse);
    }

    public float getBiasFactor() {
        return this.biasFactor;
    }

    public boolean getEnableMotor() {
        long constraintId = this.nativeId();
        boolean result = HingeJoint.getEnableAngularMotor(constraintId);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                HingeJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                HingeJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getHingeAngle() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getHingeAngle(constraintId);
        return result;
    }

    public float getLimitSoftness() {
        return this.limitSoftness;
    }

    public final float getLowerLimit() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getLowerLimit(constraintId);
        return result;
    }

    public float getMotorTargetVelocity() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getMotorTargetVelocity(constraintId);
        return result;
    }

    public float getMaxMotorImpulse() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getMaxMotorImpulse(constraintId);
        return result;
    }

    public float getRelaxationFactor() {
        return this.relaxationFactor;
    }

    public final float getUpperLimit() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getUpperLimit(constraintId);
        return result;
    }

    public boolean isAngularOnly() {
        return this.angularOnly;
    }

    public void setAngularOnly(boolean angularOnly) {
        this.angularOnly = angularOnly;
        long constraintId = this.nativeId();
        HingeJoint.setAngularOnly(constraintId, angularOnly);
    }

    public void setLimit(float low, float high) {
        long constraintId = this.nativeId();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public void setLimit(float low, float high, float softness, float bias, float relaxation) {
        long constraintId = this.nativeId();
        this.biasFactor = bias;
        this.relaxationFactor = relaxation;
        this.limitSoftness = softness;
        HingeJoint.setLimit(constraintId, low, high, softness, bias, relaxation);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        assert (this.axisA.isUnitVector()) : this.axisA;
        assert (this.pivotB != null);
        assert (this.axisB.isUnitVector()) : this.axisB;
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            Vector3f saveLocation = a.getPhysicsLocation(null);
            Quaternion saveRotation = a.getPhysicsRotation(null);
            Vector3f cross = this.axisB.cross(this.axisA);
            float sinAngle = cross.length();
            float cosAngle = this.axisB.dot(this.axisA);
            float angle = FastMath.atan2(sinAngle, cosAngle);
            MyVector3f.normalizeLocal(cross);
            Quaternion rotation = new Quaternion();
            rotation.fromAngleNormalAxis(angle, cross);
            a.setPhysicsRotation(rotation);
            Vector3f offset = this.pivotB.subtract(this.pivotA);
            a.setPhysicsLocation(offset);
            constraintId = HingeJoint.createJoint1(aId, this.pivotA, this.axisA, this.useReferenceFrameA);
            a.setPhysicsLocation(saveLocation);
            a.setPhysicsRotation(saveRotation);
        } else {
            assert (!this.useReferenceFrameA);
            long bId = b.nativeId();
            constraintId = HingeJoint.createJoint(aId, bId, this.pivotA, this.axisA, this.pivotB, this.axisB);
        }
        assert (HingeJoint.getConstraintType(constraintId) == 4);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5, Vector3f var6, Vector3f var7);

    private static native long createJoint1(long var0, Vector3f var2, Vector3f var3, boolean var4);

    private static native void enableMotor(long var0, boolean var2, float var3, float var4);

    private static native boolean getEnableAngularMotor(long var0);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native float getHingeAngle(long var0);

    private static native float getLowerLimit(long var0);

    private static native float getMaxMotorImpulse(long var0);

    private static native float getMotorTargetVelocity(long var0);

    private static native float getUpperLimit(long var0);

    private static native void setAngularOnly(long var0, boolean var2);

    private static native void setLimit(long var0, float var2, float var3, float var4, float var5, float var6);
}

