/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;

public class ConeJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(ConeJoint.class.getName());
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Matrix3f rotA;
    private final Matrix3f rotB;
    private float swingSpan1 = 1.0E30f;
    private float swingSpan2 = 1.0E30f;
    private float twistSpan = 1.0E30f;
    private boolean angularOnly = false;

    public ConeJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Matrix3f rotInA) {
        super(rigidBodyA, JointEnd.A, pivotInA, translateIdentity);
        this.rotB = this.rotA = rotInA.clone();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.createJoint();
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                ConeJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                ConeJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getSwingSpan1() {
        return this.swingSpan1;
    }

    public float getSwingSpan2() {
        return this.swingSpan2;
    }

    public float getTwistSpan() {
        return this.twistSpan;
    }

    public boolean isAngularOnly() {
        return this.angularOnly;
    }

    public void setAngularOnly(boolean value) {
        long constraintId = this.nativeId();
        this.angularOnly = value;
        ConeJoint.setAngularOnly(constraintId, value);
    }

    public void setLimit(float swingSpan1, float swingSpan2, float twistSpan) {
        long constraintId = this.nativeId();
        this.swingSpan1 = swingSpan1;
        this.swingSpan2 = swingSpan2;
        this.twistSpan = twistSpan;
        ConeJoint.setLimit(constraintId, swingSpan1, swingSpan2, twistSpan);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            constraintId = ConeJoint.createJoint1(aId, this.pivotA, this.rotA);
        } else {
            assert (this.pivotB != null);
            assert (this.rotB != null);
            long bId = b.nativeId();
            constraintId = ConeJoint.createJoint(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB);
        }
        assert (ConeJoint.getConstraintType(constraintId) == 5);
        this.setNativeId(constraintId);
        this.setLimit(this.swingSpan1, this.swingSpan2, this.twistSpan);
        this.setAngularOnly(this.angularOnly);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7);

    private static native long createJoint1(long var0, Vector3f var2, Matrix3f var3);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void setAngularOnly(long var0, boolean var2);

    private static native void setLimit(long var0, float var2, float var3, float var4);
}

