/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class Anchor
extends PhysicsJoint {
    public static final Logger logger2 = Logger.getLogger(Anchor.class.getName());
    private final boolean allowCollisions;
    private float influence = 1.0f;
    private final int nodeIndexA;
    private final Vector3f pivotInB;

    public Anchor(PhysicsSoftBody softBodyA, int nodeIndexA, PhysicsRigidBody rigidBodyB, Vector3f pivotInB, boolean allowCollisions) {
        int numNodes = softBodyA.countNodes();
        Validate.inRange(nodeIndexA, "node index", 0, numNodes - 1);
        Validate.nonNull(rigidBodyB, "rigid body B");
        Validate.finite(pivotInB, "pivot location");
        this.setBodyA(softBodyA);
        softBodyA.addJoint(this);
        this.nodeIndexA = nodeIndexA;
        this.setBodyB(rigidBodyB);
        rigidBodyB.addJoint(this);
        this.allowCollisions = allowCollisions;
        this.pivotInB = pivotInB.clone();
        this.createAnchor();
    }

    public Vector3f copyPivot(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.pivotInB.clone() : storeResult.set(this.pivotInB);
        return result;
    }

    public PhysicsRigidBody getRigidBody() {
        PhysicsRigidBody result = (PhysicsRigidBody)this.getBodyB();
        assert (result != null);
        return result;
    }

    public PhysicsSoftBody getSoftBody() {
        PhysicsSoftBody result = (PhysicsSoftBody)this.getBodyA();
        assert (result != null);
        return result;
    }

    public float influence() {
        return this.influence;
    }

    public boolean isAllowCollision() {
        return this.allowCollisions;
    }

    public int nodeIndex() {
        assert (this.nodeIndexA >= 0) : this.nodeIndexA;
        return this.nodeIndexA;
    }

    public void setInfluence(float amount) {
        Validate.fraction(amount, "amount");
        this.influence = amount;
        long anchorId = this.nativeId();
        Anchor.setInfluence(anchorId, amount);
    }

    public void setPivotInB(Vector3f location) {
        Validate.nonNull(location, "location");
        this.pivotInB.set(location);
        long anchorId = this.nativeId();
        Anchor.setPivotInB(anchorId, location);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void createAnchor() {
        PhysicsSoftBody a = this.getSoftBody();
        long aId = a.nativeId();
        assert (this.nodeIndexA >= 0) : this.nodeIndexA;
        assert (this.nodeIndexA < a.countNodes()) : this.nodeIndexA;
        PhysicsRigidBody b = this.getRigidBody();
        long bId = b.nativeId();
        long anchorId = Anchor.createAnchor(aId, this.nodeIndexA, bId, this.pivotInB, this.allowCollisions, this.influence);
        this.setNativeIdNotTracked(anchorId);
    }

    private static native long createAnchor(long var0, int var2, long var3, Vector3f var5, boolean var6, float var7);

    private static native void setInfluence(long var0, float var2);

    private static native void setPivotInB(long var0, Vector3f var2);
}

