/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.math.Plane;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.DistinctVectorValues;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public class IndexedMesh
extends NativePhysicsObject {
    private static final int floatBytes = 4;
    private static final int intBytes = 4;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(IndexedMesh.class.getName());
    private final FloatBuffer vertexPositions;
    private final IntBuffer indices;
    private final int indexStride;
    private final int numTriangles;
    private final int numVertices;
    private final int vertexStride;

    public IndexedMesh(Vector3f[] positionArray, int[] indexArray) {
        Validate.nonNull(positionArray, "position array");
        Validate.nonNull(indexArray, "index array");
        int numIndices = indexArray.length;
        Validate.require(numIndices % 3 == 0, "length a multiple of 3");
        this.numVertices = positionArray.length;
        this.vertexPositions = BufferUtils.createFloatBuffer(positionArray);
        this.vertexStride = 12;
        this.numTriangles = numIndices / 3;
        this.indices = BufferUtils.createIntBuffer(indexArray);
        this.indexStride = 12;
        this.createMesh();
    }

    public IndexedMesh(FloatBuffer buffer) {
        Validate.nonNull(buffer, "buffer");
        int numFloats = buffer.limit();
        Validate.require(numFloats % 9 == 0, "limit a multiple of 9");
        DistinctVectorValues dvv = new DistinctVectorValues(buffer, 0, numFloats);
        this.numVertices = dvv.countDistinct();
        this.vertexPositions = BufferUtils.createFloatBuffer(3 * this.numVertices);
        this.vertexStride = 12;
        int numIndices = numFloats / 3;
        this.numTriangles = numIndices / 3;
        this.indices = BufferUtils.createIntBuffer(numIndices);
        this.indexStride = 12;
        Vector3f tmpVector = new Vector3f();
        for (int oldVi = 0; oldVi < numIndices; ++oldVi) {
            int newVi = dvv.findVvid(oldVi);
            assert (newVi >= 0) : newVi;
            this.indices.put(oldVi, newVi);
            int readPosition = 3 * oldVi;
            MyBuffer.get(buffer, readPosition, tmpVector);
            int writePosition = 3 * newVi;
            MyBuffer.put(this.vertexPositions, writePosition, tmpVector);
        }
        this.createMesh();
    }

    IndexedMesh(FloatBuffer positionBuffer, IntBuffer indexBuffer) {
        Validate.nonNull(positionBuffer, "position buffer");
        Validate.nonNull(indexBuffer, "index buffer");
        int numFloats = positionBuffer.capacity();
        Validate.require(numFloats % 3 == 0, "capacity a multiple of 3");
        int numIndices = indexBuffer.capacity();
        Validate.require(numIndices % 3 == 0, "capacity a multiple of 3");
        this.numVertices = numFloats / 3;
        this.vertexPositions = positionBuffer;
        this.vertexStride = 12;
        this.numTriangles = numIndices / 3;
        this.indices = indexBuffer;
        this.indexStride = 12;
        this.createMesh();
    }

    public IntBuffer copyIndices() {
        int numInts = this.indices.capacity();
        IntBuffer result = BufferUtils.createIntBuffer(numInts);
        for (int bufPos = 0; bufPos < numInts; ++bufPos) {
            int tmpIndex = this.indices.get(bufPos);
            result.put(tmpIndex);
        }
        return result;
    }

    public void copyTriangle(int triangleIndex, Triangle destination) {
        Validate.inRange(triangleIndex, "triangle index", 0, this.numTriangles - 1);
        Validate.nonNull(destination, "destination");
        int startPosition = triangleIndex * 3;
        Vector3f tmpVector = new Vector3f();
        for (int vertexI = 0; vertexI < 3; ++vertexI) {
            int indexPosition = startPosition + vertexI;
            int vertexIndex = this.indices.get(indexPosition);
            MyBuffer.get(this.vertexPositions, vertexIndex * 3, tmpVector);
            destination.set(vertexI, tmpVector);
        }
    }

    public FloatBuffer copyVertexPositions() {
        int numFloats = this.numVertices * 3;
        FloatBuffer result = BufferUtils.createFloatBuffer(numFloats);
        for (int bufPos = 0; bufPos < numFloats; ++bufPos) {
            float tmpFloat = this.vertexPositions.get(bufPos);
            result.put(tmpFloat);
        }
        return result;
    }

    public int countTriangles() {
        assert (this.numTriangles >= 0) : this.numTriangles;
        return this.numTriangles;
    }

    public int countVertices() {
        assert (this.numVertices >= 0) : this.numVertices;
        return this.numVertices;
    }

    public void maxMin(Vector3f storeMaxima, Vector3f storeMinima) {
        Validate.nonNull(storeMaxima, "store maxima");
        Validate.nonNull(storeMinima, "store minima");
        int numFloats = this.numVertices * 3;
        MyBuffer.maxMin(this.vertexPositions, 0, numFloats, storeMaxima, storeMinima);
    }

    public IndexedMesh[] split(Plane splittingPlane) {
        IndexedMesh[] result;
        block4: {
            FloatBuffer[] buffers;
            block2: {
                int numPlus;
                block3: {
                    Validate.nonNull(splittingPlane, "splitting plane");
                    buffers = new FloatBuffer[2];
                    int cap = 2 * this.numTriangles * 3 * 3;
                    buffers[0] = BufferUtils.createFloatBuffer(cap);
                    buffers[1] = BufferUtils.createFloatBuffer(cap);
                    Triangle triangle = new Triangle();
                    for (int triangleI = 0; triangleI < this.numTriangles; ++triangleI) {
                        this.copyTriangle(triangleI, triangle);
                        IndexedMesh.splitTriangle(triangle, splittingPlane, buffers);
                    }
                    result = new IndexedMesh[2];
                    int numMinus = buffers[0].position();
                    numPlus = buffers[1].position();
                    if (numMinus != 0 && numPlus != 0) break block2;
                    if (numMinus <= 0) break block3;
                    result[0] = this;
                    break block4;
                }
                if (numPlus <= 0) break block4;
                result[1] = this;
                break block4;
            }
            for (int sideI = 0; sideI < 2; ++sideI) {
                buffers[sideI].flip();
                result[sideI] = new IndexedMesh(buffers[sideI]);
            }
        }
        return result;
    }

    private void createMesh() {
        assert (this.vertexStride == 12) : this.vertexStride;
        assert (this.indexStride == 12) : this.indexStride;
        long meshId = IndexedMesh.createInt(this.indices, this.vertexPositions, this.numTriangles, this.numVertices, this.vertexStride, this.indexStride);
        this.setNativeId(meshId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    private static void freeNativeObject(long meshId) {
        assert (meshId != 0L);
        IndexedMesh.finalizeNative(meshId);
    }

    private static void putTriangle(FloatBuffer buffer, Vector3f v1, Vector3f v2, Vector3f v3) {
        if (v1.equals(v2) || v1.equals(v3) || v2.equals(v3)) {
            return;
        }
        buffer.put(v1.x).put(v1.y).put(v1.z);
        buffer.put(v2.x).put(v2.y).put(v2.z);
        buffer.put(v3.x).put(v3.y).put(v3.z);
    }

    private static void splitTriangle(Triangle input, Plane splittingPlane, FloatBuffer[] putResults) {
        Vector3f a = input.get1();
        Vector3f b = input.get2();
        Vector3f c = input.get3();
        float aa = splittingPlane.pseudoDistance(a);
        float bb = splittingPlane.pseudoDistance(b);
        float cc = splittingPlane.pseudoDistance(c);
        if (aa == 0.0f && bb == 0.0f && cc == 0.0f) {
            IndexedMesh.putTriangle(putResults[0], a, b, c);
            IndexedMesh.putTriangle(putResults[1], a, b, c);
        } else if (aa <= 0.0f && bb <= 0.0f && cc <= 0.0f) {
            IndexedMesh.putTriangle(putResults[0], a, b, c);
        } else if (aa >= 0.0f && bb >= 0.0f && cc >= 0.0f) {
            IndexedMesh.putTriangle(putResults[1], a, b, c);
        } else if (aa >= 0.0f && bb <= 0.0f && cc <= 0.0f) {
            float tab = aa / (aa - bb);
            Vector3f ab = MyVector3f.lerp(tab, a, b, null);
            float tac = aa / (aa - cc);
            Vector3f ac = MyVector3f.lerp(tac, a, c, null);
            IndexedMesh.putTriangle(putResults[0], b, c, ac);
            IndexedMesh.putTriangle(putResults[0], b, ac, ab);
            IndexedMesh.putTriangle(putResults[1], a, ab, ac);
        } else if (aa <= 0.0f && bb >= 0.0f && cc >= 0.0f) {
            float tab = -aa / (bb - aa);
            Vector3f ab = MyVector3f.lerp(tab, a, b, null);
            float tac = -aa / (cc - aa);
            Vector3f ac = MyVector3f.lerp(tac, a, c, null);
            IndexedMesh.putTriangle(putResults[1], b, c, ac);
            IndexedMesh.putTriangle(putResults[1], b, ac, ab);
            IndexedMesh.putTriangle(putResults[0], a, ab, ac);
        } else if (aa <= 0.0f && bb >= 0.0f && cc <= 0.0f) {
            float tab = -aa / (bb - aa);
            Vector3f ab = MyVector3f.lerp(tab, a, b, null);
            float tbc = bb / (bb - cc);
            Vector3f bc = MyVector3f.lerp(tbc, b, c, null);
            IndexedMesh.putTriangle(putResults[0], a, bc, c);
            IndexedMesh.putTriangle(putResults[0], a, ab, bc);
            IndexedMesh.putTriangle(putResults[1], b, bc, ab);
        } else if (aa >= 0.0f && bb <= 0.0f && cc >= 0.0f) {
            float tab = aa / (aa - bb);
            Vector3f ab = MyVector3f.lerp(tab, a, b, null);
            float tbc = -bb / (cc - bb);
            Vector3f bc = MyVector3f.lerp(tbc, b, c, null);
            IndexedMesh.putTriangle(putResults[1], a, bc, c);
            IndexedMesh.putTriangle(putResults[1], a, ab, bc);
            IndexedMesh.putTriangle(putResults[0], b, bc, ab);
        } else if (aa <= 0.0f && bb <= 0.0f && cc >= 0.0f) {
            float tac = -aa / (cc - aa);
            Vector3f ac = MyVector3f.lerp(tac, a, c, null);
            float tbc = -bb / (cc - bb);
            Vector3f bc = MyVector3f.lerp(tbc, b, c, null);
            IndexedMesh.putTriangle(putResults[0], a, b, bc);
            IndexedMesh.putTriangle(putResults[0], a, bc, ac);
            IndexedMesh.putTriangle(putResults[1], ac, bc, c);
        } else {
            assert (aa >= 0.0f) : aa;
            assert (bb >= 0.0f) : bb;
            assert (cc <= 0.0f) : cc;
            float tac = aa / (aa - cc);
            Vector3f ac = MyVector3f.lerp(tac, a, c, null);
            float tbc = bb / (bb - cc);
            Vector3f bc = MyVector3f.lerp(tbc, b, c, null);
            IndexedMesh.putTriangle(putResults[1], a, b, bc);
            IndexedMesh.putTriangle(putResults[1], a, bc, ac);
            IndexedMesh.putTriangle(putResults[0], ac, bc, c);
        }
    }

    private static native long createByte(ByteBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createInt(IntBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native long createShort(ShortBuffer var0, FloatBuffer var1, int var2, int var3, int var4, int var5);

    private static native void finalizeNative(long var0);
}

