/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.EmptyShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class ChildCollisionShape {
    public static final Logger logger = Logger.getLogger(ChildCollisionShape.class.getName());
    private final CollisionShape shape;
    private final Matrix3f rotation;
    private final Vector3f offset;

    public ChildCollisionShape(Vector3f offset, Matrix3f rotation, CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalArgumentException("CompoundCollisionShapes cannot be child shapes!");
        }
        this.offset = offset.clone();
        this.rotation = rotation.clone();
        this.shape = shape;
    }

    public ChildCollisionShape(Vector3f offset, CollisionShape shape) {
        Validate.nonNull(shape, "shape");
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalArgumentException("CompoundCollisionShapes cannot be child shapes!");
        }
        this.offset = offset.clone();
        this.rotation = new Matrix3f();
        this.shape = shape;
    }

    public Vector3f copyOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.offset.clone() : storeResult.set(this.offset);
        return result;
    }

    public Quaternion copyRotation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        result.fromRotationMatrix(this.rotation);
        return result;
    }

    public Matrix3f copyRotationMatrix(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? this.rotation.clone() : storeResult.set(this.rotation);
        return result;
    }

    public Transform copyTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.setTranslation(this.offset);
        result.getRotation().fromRotationMatrix(this.rotation);
        result.setScale(1.0f);
        return result;
    }

    public CollisionShape getShape() {
        assert (this.shape != null);
        return this.shape;
    }

    public void setTransform(Vector3f offset, Matrix3f rotation) {
        this.offset.set(offset);
        this.rotation.set(rotation);
    }

    public ChildCollisionShape[] split(Triangle parentTriangle) {
        Validate.nonNull(parentTriangle, "parent triangle");
        ChildCollisionShape[] result = new ChildCollisionShape[2];
        if (this.shape instanceof EmptyShape) {
            return result;
        }
        HullCollisionShape hull = (HullCollisionShape)this.shape;
        Transform c2pTransform = this.copyTransform(null);
        this.shape.getScale(c2pTransform.getScale());
        Triangle childTriangle = MyMath.transformInverse(c2pTransform, parentTriangle, null);
        ChildCollisionShape[] mp = hull.split(childTriangle);
        Transform tmpTransform = new Transform();
        for (int i = 0; i < 2; ++i) {
            if (mp[i] == null) continue;
            mp[i].copyTransform(tmpTransform);
            tmpTransform.combineWithParent(c2pTransform);
            Vector3f newOffset = tmpTransform.getTranslation();
            CollisionShape base = mp[i].getShape();
            result[i] = new ChildCollisionShape(newOffset, this.rotation, base);
        }
        return result;
    }
}

