/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class BoundingValueHierarchy
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(BoundingValueHierarchy.class.getName());

    public BoundingValueHierarchy(MeshCollisionShape meshShape) {
        Validate.nonNull(meshShape, "mesh shape");
        long shapeId = meshShape.nativeId();
        long bvhId = BoundingValueHierarchy.getOptimizedBvh(shapeId);
        super.setNativeIdNotTracked(bvhId);
    }

    public BoundingValueHierarchy(byte[] bytes) {
        Validate.nonNull(bytes, "bytes");
        long bvhId = BoundingValueHierarchy.deSerialize(bytes);
        super.setNativeId(bvhId);
    }

    public byte[] serialize() {
        long bvhId = this.nativeId();
        byte[] result = BoundingValueHierarchy.serialize(bvhId);
        assert (result != null);
        return result;
    }

    private static void freeNativeObject(long bvhId) {
        assert (bvhId != 0L);
        BoundingValueHierarchy.finalizeNative(bvhId);
    }

    private static native long deSerialize(byte[] var0);

    private static native void finalizeNative(long var0);

    private static native long getOptimizedBvh(long var0);

    private static native byte[] serialize(long var0);
}

