/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVolume;
import jme3utilities.math.RectangularSolid;

public class MultiSphere
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(MultiSphere.class.getName());
    private final float[] radii;
    private final Vector3f[] centers;

    public MultiSphere(float radius) {
        Validate.nonNegative(radius, "radius");
        this.centers = new Vector3f[1];
        this.centers[0] = new Vector3f(0.0f, 0.0f, 0.0f);
        this.radii = new float[]{radius};
        this.createShape();
    }

    public MultiSphere(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float halfHeight = height / 2.0f;
        this.centers = new Vector3f[2];
        this.centers[0] = new Vector3f(0.0f, halfHeight, 0.0f);
        this.centers[1] = new Vector3f(0.0f, -halfHeight, 0.0f);
        this.radii = new float[]{radius, radius};
        this.createShape();
    }

    public MultiSphere(float radius, float height, int axisIndex) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float halfHeight = height / 2.0f;
        this.centers = new Vector3f[2];
        switch (axisIndex) {
            case 0: {
                this.centers[0] = new Vector3f(halfHeight, 0.0f, 0.0f);
                this.centers[1] = new Vector3f(-halfHeight, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.centers[0] = new Vector3f(0.0f, halfHeight, 0.0f);
                this.centers[1] = new Vector3f(0.0f, -halfHeight, 0.0f);
                break;
            }
            case 2: {
                this.centers[0] = new Vector3f(0.0f, 0.0f, halfHeight);
                this.centers[1] = new Vector3f(0.0f, 0.0f, -halfHeight);
                break;
            }
            default: {
                throw new IllegalArgumentException("axisIndex = " + axisIndex);
            }
        }
        this.radii = new float[]{radius, radius};
        this.createShape();
    }

    public MultiSphere(List<Vector3f> centers, List<Float> radii) {
        Validate.nonEmpty(centers, "centers");
        Validate.nonEmpty(radii, "radii");
        int numSpheres = radii.size();
        Validate.require(centers.size() == numSpheres, "lists of equal length");
        this.centers = new Vector3f[numSpheres];
        this.radii = new float[numSpheres];
        for (int i = 0; i < numSpheres; ++i) {
            this.centers[i] = centers.get(i).clone();
            float radius = radii.get(i).floatValue();
            assert (radius >= 0.0f) : radius;
            this.radii[i] = radius;
        }
        this.createShape();
    }

    public MultiSphere(RectangularSolid rectangularSolid) {
        Vector3f halfExtents = rectangularSolid.halfExtents(null);
        float radius = MyMath.min(halfExtents.x, halfExtents.y, halfExtents.z);
        Vector3f max = rectangularSolid.maxima(null);
        max.subtractLocal(radius, radius, radius);
        Vector3f min = rectangularSolid.minima(null);
        min.addLocal(radius, radius, radius);
        ArrayList<Vector3f> centerLocations = new ArrayList<Vector3f>(4);
        if (radius == halfExtents.x) {
            float x = max.x;
            centerLocations.add(new Vector3f(x, max.y, max.z));
            centerLocations.add(new Vector3f(x, max.y, min.z));
            centerLocations.add(new Vector3f(x, min.y, max.z));
            centerLocations.add(new Vector3f(x, min.y, min.z));
        } else if (radius == halfExtents.y) {
            float y = max.y;
            centerLocations.add(new Vector3f(max.x, y, max.z));
            centerLocations.add(new Vector3f(max.x, y, min.z));
            centerLocations.add(new Vector3f(min.x, y, max.z));
            centerLocations.add(new Vector3f(min.x, y, min.z));
        } else {
            assert (radius == halfExtents.z);
            float z = max.z;
            centerLocations.add(new Vector3f(max.x, max.y, z));
            centerLocations.add(new Vector3f(max.x, min.y, z));
            centerLocations.add(new Vector3f(min.x, max.y, z));
            centerLocations.add(new Vector3f(min.x, min.y, z));
        }
        this.centers = new Vector3f[4];
        this.radii = new float[]{radius, radius, radius, radius};
        for (int sphereI = 0; sphereI < 4; ++sphereI) {
            Vector3f localCenter = (Vector3f)centerLocations.get(sphereI);
            this.centers[sphereI] = rectangularSolid.localToWorld(localCenter, null);
        }
        this.createShape();
    }

    public MultiSphere(Vector3f center, float radius) {
        Validate.finite(center, "center");
        Validate.nonNegative(radius, "radius");
        this.centers = new Vector3f[1];
        this.centers[0] = center.clone();
        this.radii = new float[]{radius};
        this.createShape();
    }

    public MultiSphere(Vector3f[] centers, float ... radii) {
        Validate.nonEmpty(centers, "centers");
        Validate.nonEmpty(radii, "radii");
        int numSpheres = radii.length;
        Validate.require(centers.length == numSpheres, "arrays of equal length");
        this.centers = new Vector3f[numSpheres];
        this.radii = new float[numSpheres];
        for (int i = 0; i < numSpheres; ++i) {
            this.centers[i] = centers[i].clone();
            float radius = radii[i];
            assert (radius >= 0.0f) : radius;
            this.radii[i] = radius;
        }
        this.createShape();
    }

    public Vector3f copyCenter(int sphereIndex, Vector3f storeResult) {
        Validate.inRange(sphereIndex, "sphere index", 0, this.radii.length - 1);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.centers[sphereIndex]);
        return result;
    }

    public int countSpheres() {
        int count = this.radii.length;
        assert (count > 0) : count;
        return count;
    }

    public float getRadius(int sphereIndex) {
        Validate.inRange(sphereIndex, "sphere index", 0, this.radii.length - 1);
        float radius = this.radii[sphereIndex];
        assert (radius >= 0.0f) : radius;
        return radius;
    }

    @Override
    protected void recalculateAabb() {
        long shapeId = this.nativeId();
        MultiSphere.recalcAabb(shapeId);
    }

    @Override
    public float scaledVolume() {
        float volume;
        int numSpheres = this.radii.length;
        if (numSpheres == 1) {
            float radius = this.radii[0];
            float unscaledVolume = MyVolume.sphereVolume(radius);
            volume = unscaledVolume * this.scale.x * this.scale.y * this.scale.z;
        } else if (numSpheres == 2 && this.radii[0] == this.radii[1]) {
            float radius = this.radii[0];
            float height = this.centers[0].distance(this.centers[1]);
            float unscaledVolume = MyVolume.capsuleVolume(radius, height);
            volume = unscaledVolume * this.scale.x * this.scale.y * this.scale.z;
        } else {
            volume = super.scaledVolume();
        }
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    @Override
    public HullCollisionShape toHullShape() {
        float medianScale = MyMath.mid(this.scale.x, this.scale.y, this.scale.z);
        assert (medianScale > 0.0f) : medianScale;
        float minRadius = MyMath.min(this.radii);
        float defaultMargin = MultiSphere.getDefaultMargin();
        float hullMargin = Math.min(defaultMargin, minRadius * medianScale);
        int numSpheres = this.radii.length;
        float[] reducedRadii = new float[numSpheres];
        for (int sphereIndex = 0; sphereIndex < numSpheres; ++sphereIndex) {
            float rr = this.radii[sphereIndex] - hullMargin / medianScale;
            if (rr < 1.0E-6f) {
                rr = 1.0E-6f;
            }
            reducedRadii[sphereIndex] = rr;
        }
        MultiSphere reducedShape = new MultiSphere(this.centers, reducedRadii);
        reducedShape.setScale(this.scale);
        FloatBuffer buffer = DebugShapeFactory.debugVertices(reducedShape, 0);
        buffer.rewind();
        buffer.limit(buffer.capacity());
        HullCollisionShape result = new HullCollisionShape(buffer);
        result.setMargin(hullMargin);
        return result;
    }

    private void createShape() {
        int numSpheres = this.radii.length;
        assert (this.centers.length == numSpheres) : numSpheres;
        long shapeId = MultiSphere.createShape(this.centers, this.radii, numSpheres);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f[] var0, float[] var1, int var2);

    private static native void recalcAabb(long var0);
}

