/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.util.DebugShapeFactory;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public abstract class ConvexShape
extends CollisionShape {
    public static final Logger loggerX = Logger.getLogger(ConvexShape.class.getName());

    protected ConvexShape() {
    }

    public HullCollisionShape toHullShape() {
        FloatBuffer buffer = DebugShapeFactory.debugVertices(this, 0);
        buffer.rewind();
        buffer.limit(buffer.capacity());
        HullCollisionShape result = new HullCollisionShape(buffer);
        return result;
    }

    @Override
    public boolean isConcave() {
        assert (!super.isConcave());
        return false;
    }

    @Override
    public boolean isConvex() {
        assert (super.isConvex());
        return true;
    }

    @Override
    public float scaledVolume() {
        int meshResolution = 0;
        float result = DebugShapeFactory.volumeConvex(this, meshResolution);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public CollisionShape toSplittableShape() {
        ConvexShape result = this.canSplit() ? this : this.toHullShape();
        return result;
    }
}

