/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;
import jme3utilities.math.RectangularSolid;

public class BoxCollisionShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(BoxCollisionShape.class.getName());
    private final Vector3f halfExtents = new Vector3f(1.0f, 1.0f, 1.0f);

    public BoxCollisionShape(float halfExtent) {
        Validate.nonNegative(halfExtent, "half extent");
        this.halfExtents.set(halfExtent, halfExtent, halfExtent);
        this.createShape();
    }

    public BoxCollisionShape(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        Validate.nonNegative(xHalfExtent, "half extent on X");
        Validate.nonNegative(yHalfExtent, "half extent on Y");
        Validate.nonNegative(zHalfExtent, "half extent on Z");
        this.halfExtents.set(xHalfExtent, yHalfExtent, zHalfExtent);
        this.createShape();
    }

    public BoxCollisionShape(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        MyBuffer.maxAbs(buffer, startPosition, endPosition, this.halfExtents);
        this.createShape();
    }

    public BoxCollisionShape(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        this.halfExtents.set(halfExtents);
        this.createShape();
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        assert (MyVector3f.isAllNonNegative(this.halfExtents)) : this.halfExtents;
        Vector3f result = storeResult == null ? this.halfExtents.clone() : storeResult.set(this.halfExtents);
        return result;
    }

    public float unscaledVolume() {
        float result = MyVolume.boxVolume(this.halfExtents);
        assert (result >= 0.0f) : result;
        return result;
    }

    @Override
    public float maxRadius() {
        double xx = this.scale.x * this.halfExtents.x;
        double yy = this.scale.y * this.halfExtents.y;
        double zz = this.scale.z * this.halfExtents.z;
        float result = (float)MyMath.hypotenuseDouble(xx, yy, zz);
        return result;
    }

    @Override
    public float scaledVolume() {
        float result = this.unscaledVolume() * this.scale.x * this.scale.y * this.scale.z;
        return result;
    }

    @Override
    public HullCollisionShape toHullShape() {
        float defaultMargin;
        Vector3f hes = this.scale.mult(this.halfExtents);
        float[] fArray = new float[]{hes.x, hes.y, hes.z};
        float minHalfExtent = MyMath.min(fArray);
        float hullMargin = Math.min(minHalfExtent, defaultMargin = BoxCollisionShape.getDefaultMargin());
        if (hullMargin <= 1.0E-9f) {
            hullMargin = 1.0E-9f;
        }
        hes.subtractLocal(hullMargin, hullMargin, hullMargin);
        RectangularSolid shrunkenSolid = new RectangularSolid(hes);
        HullCollisionShape result = new HullCollisionShape(shrunkenSolid);
        result.setMargin(hullMargin);
        return result;
    }

    private void createShape() {
        assert (MyVector3f.isAllNonNegative(this.halfExtents)) : this.halfExtents;
        long shapeId = BoxCollisionShape.createShape(this.halfExtents);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(Vector3f var0);
}

