/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.ConvexShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Box2dShape
extends ConvexShape {
    public static final Logger logger2 = Logger.getLogger(Box2dShape.class.getName());
    private float halfExtentX = 1.0f;
    private float halfExtentY = 1.0f;

    public Box2dShape(float halfExtent) {
        Validate.nonNegative(halfExtent, "half extent");
        this.halfExtentX = halfExtent;
        this.halfExtentY = halfExtent;
        this.createShape();
    }

    public Box2dShape(float xHalfExtent, float yHalfExtent) {
        Validate.nonNegative(xHalfExtent, "half extent on X");
        Validate.nonNegative(yHalfExtent, "half extent on Y");
        this.halfExtentX = xHalfExtent;
        this.halfExtentY = yHalfExtent;
        this.createShape();
    }

    public Box2dShape(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        this.halfExtentX = halfExtents.x;
        this.halfExtentY = halfExtents.y;
        this.createShape();
    }

    public Vector3f getHalfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.halfExtentX, this.halfExtentY, this.margin);
        return result;
    }

    @Override
    public float maxRadius() {
        float x = this.scale.x * this.halfExtentX;
        float y = this.scale.y * this.halfExtentY;
        float result = MyMath.hypotenuse(x, y);
        return result;
    }

    private void createShape() {
        assert (this.halfExtentX >= 0.0f) : this.halfExtentX;
        assert (this.halfExtentY >= 0.0f) : this.halfExtentY;
        long shapeId = Box2dShape.createShape(this.halfExtentX, this.halfExtentY, this.margin);
        this.setNativeId(shapeId);
        this.setContactFilterEnabled(this.enableContactFilter);
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private static native long createShape(float var0, float var1, float var2);
}

