/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.TransformDp;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public abstract class PhysicsCollisionObject
extends NativePhysicsObject {
    public static final int COLLISION_GROUP_NONE = 0;
    public static final int COLLISION_GROUP_01 = 1;
    public static final int COLLISION_GROUP_02 = 2;
    public static final int COLLISION_GROUP_03 = 4;
    public static final int COLLISION_GROUP_04 = 8;
    public static final int COLLISION_GROUP_05 = 16;
    public static final int COLLISION_GROUP_06 = 32;
    public static final int COLLISION_GROUP_07 = 64;
    public static final int COLLISION_GROUP_08 = 128;
    public static final int COLLISION_GROUP_09 = 256;
    public static final int COLLISION_GROUP_10 = 512;
    public static final int COLLISION_GROUP_11 = 1024;
    public static final int COLLISION_GROUP_12 = 2048;
    public static final int COLLISION_GROUP_13 = 4096;
    public static final int COLLISION_GROUP_14 = 8192;
    public static final int COLLISION_GROUP_15 = 16384;
    public static final int COLLISION_GROUP_16 = 32768;
    public static final Logger logger = Logger.getLogger(PhysicsCollisionObject.class.getName());
    private CollisionShape collisionShape;
    private int collideWithGroups = 1;
    private int collisionGroup = 1;
    private Object userObject = null;

    protected PhysicsCollisionObject() {
    }

    public void activate(boolean forceFlag) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.activate(objectId, forceFlag);
    }

    public void addCollideWithGroup(int collisionGroup) {
        this.collideWithGroups |= collisionGroup;
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            PhysicsCollisionObject.setCollideWithGroups(objectId, this.collideWithGroups);
        }
    }

    public void addToIgnoreList(PhysicsCollisionObject otherPco) {
        Validate.nonNull(otherPco, "other");
        Validate.require(otherPco != this, "2 distinct collision objects");
        if (!this.ignores(otherPco)) {
            long thisId = this.nativeId();
            long otherId = otherPco.nativeId();
            boolean toIgnore = true;
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
        }
    }

    public BoundingBox boundingBox(BoundingBox storeResult) {
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        Vector3f translation = this.getPhysicsLocation(null);
        Matrix3f rotation = this.getPhysicsRotationMatrix(null);
        this.collisionShape.boundingBox(translation, rotation, result);
        return result;
    }

    public void clearIgnoreList() {
        long[] otherIds;
        long thisId = this.nativeId();
        for (long otherId : otherIds = this.listIgnoredIds()) {
            boolean toIgnore = false;
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
        }
    }

    public int collisionFlags() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getCollisionFlags(objectId);
        return result;
    }

    public final void copyPcoProperties(PhysicsCollisionObject old) {
        assert (old.hasAssignedNativeObject());
        assert (old.nativeId() != this.nativeId());
        int flags = old.collisionFlags();
        boolean hasCsd = (flags & 0x80) != 0;
        this.setCcdMotionThreshold(old.getCcdMotionThreshold());
        this.setCcdSweptSphereRadius(old.getCcdSweptSphereRadius());
        if (hasCsd) {
            this.setContactDamping(old.getContactDamping());
        }
        this.setContactProcessingThreshold(old.getContactProcessingThreshold());
        if (hasCsd) {
            this.setContactStiffness(old.getContactStiffness());
        }
        this.setDeactivationTime(old.getDeactivationTime());
        this.setFriction(old.getFriction());
        this.setRestitution(old.getRestitution());
        this.setRollingFriction(old.getRollingFriction());
        this.setSpinningFriction(old.getSpinningFriction());
        if (old.hasAnisotropicFriction(1)) {
            this.setAnisotropicFriction(old.getAnisotropicFriction(null), 1);
        } else if (old.hasAnisotropicFriction(2)) {
            this.setAnisotropicFriction(old.getAnisotropicFriction(null), 2);
        }
    }

    public int countIgnored() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getNumObjectsWithoutCollision(objectId);
        assert (result >= 0) : result;
        return result;
    }

    public static native PhysicsCollisionObject findInstance(long var0);

    public int getActivationState() {
        long objectId = this.nativeId();
        int result = PhysicsCollisionObject.getActivationState(objectId);
        assert (result >= 1) : result;
        assert (result <= 5) : result;
        return result;
    }

    public Vector3f getAnisotropicFriction(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getAnisotropicFriction(objectId, result);
        return result;
    }

    public float getCcdMotionThreshold() {
        long objectId = this.nativeId();
        float distance = PhysicsCollisionObject.getCcdMotionThreshold(objectId);
        assert (distance >= 0.0f) : distance;
        return distance;
    }

    public float getCcdSquareMotionThreshold() {
        float distance = this.getCcdMotionThreshold();
        float dSquared = distance * distance;
        return dSquared;
    }

    public float getCcdSweptSphereRadius() {
        long objectId = this.nativeId();
        float radius = PhysicsCollisionObject.getCcdSweptSphereRadius(objectId);
        assert (radius >= 0.0f) : radius;
        return radius;
    }

    public int getCollideWithGroups() {
        assert (this.collideWithGroups == PhysicsCollisionObject.getCollideWithGroups(this.nativeId()));
        return this.collideWithGroups;
    }

    public int getCollisionGroup() {
        assert (this.collisionGroup == PhysicsCollisionObject.getCollisionGroup(this.nativeId()));
        assert (Integer.bitCount(this.collisionGroup) == 1) : this.collisionGroup;
        return this.collisionGroup;
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public CollisionSpace getCollisionSpace() {
        CollisionSpace result = null;
        if (this.spaceId() != 0L) {
            long objectId = this.nativeId();
            result = PhysicsCollisionObject.getCollisionSpace(objectId);
        }
        return result;
    }

    public float getContactDamping() {
        long objectId = this.nativeId();
        float damping = PhysicsCollisionObject.getContactDamping(objectId);
        return damping;
    }

    public float getContactProcessingThreshold() {
        long objectId = this.nativeId();
        float distance = PhysicsCollisionObject.getContactProcessingThreshold(objectId);
        return distance;
    }

    public float getContactStiffness() {
        long objectId = this.nativeId();
        float stiffness = PhysicsCollisionObject.getContactStiffness(objectId);
        return stiffness;
    }

    public float getDeactivationTime() {
        long objectId = this.nativeId();
        float time = PhysicsCollisionObject.getDeactivationTime(objectId);
        return time;
    }

    public float getFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getFriction(objectId);
        return result;
    }

    public Vector3f getPhysicsLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getLocation(objectId, result);
        assert (Vector3f.isValidVector(result));
        return result;
    }

    public Vec3d getPhysicsLocationDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getLocationDp(objectId, result);
        assert (MyMath.isFinite(result));
        return result;
    }

    public Quaternion getPhysicsRotation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getOrientation(objectId, result);
        return result;
    }

    public Quatd getPhysicsRotationDp(Quatd storeResult) {
        Quatd result = storeResult == null ? new Quatd() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getOrientationDp(objectId, result);
        return result;
    }

    public Matrix3f getPhysicsRotationMatrix(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getBasis(objectId, result);
        return result;
    }

    public Matrix3d getPhysicsRotationMatrixDp(Matrix3d storeResult) {
        Matrix3d result = storeResult == null ? new Matrix3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsCollisionObject.getBasisDp(objectId, result);
        return result;
    }

    public float getRestitution() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getRestitution(objectId);
        return result;
    }

    public float getRollingFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getRollingFriction(objectId);
        return result;
    }

    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result = this.collisionShape.getScale(storeResult);
        return result;
    }

    public float getSpinningFriction() {
        long objectId = this.nativeId();
        float result = PhysicsCollisionObject.getSpinningFriction(objectId);
        return result;
    }

    public Transform getTransform(Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        this.getPhysicsLocation(result.getTranslation());
        this.getPhysicsRotation(result.getRotation());
        this.getScale(result.getScale());
        return result;
    }

    public TransformDp getTransformDp(TransformDp storeResult) {
        TransformDp result = storeResult == null ? new TransformDp() : storeResult;
        this.getPhysicsLocationDp(result.getTranslation());
        this.getPhysicsRotationDp(result.getRotation());
        this.collisionShape.getScaleDp(result.getScale());
        return result;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean hasAnisotropicFriction(int mode) {
        Validate.inRange(mode, "mode", 1, 3);
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.hasAnisotropicFriction(objectId, mode);
        return result;
    }

    public boolean ignores(PhysicsCollisionObject other) {
        boolean result = false;
        if (other != null && other != this) {
            long objectId = this.nativeId();
            long otherId = other.nativeId();
            int numIgnoredObjects = PhysicsCollisionObject.getNumObjectsWithoutCollision(objectId);
            for (int index = 0; index < numIgnoredObjects; ++index) {
                long id = PhysicsCollisionObject.getObjectWithoutCollision(objectId, index);
                if (id != otherId) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isActive() {
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.isActive(objectId);
        return result;
    }

    public final boolean isContactResponse() {
        long objectId = this.nativeId();
        int flags = PhysicsCollisionObject.getCollisionFlags(objectId);
        boolean result = (flags & 4) == 0;
        return result;
    }

    public final boolean isInWorld() {
        long objectId = this.nativeId();
        boolean result = PhysicsCollisionObject.isInWorld(objectId);
        return result;
    }

    public final boolean isStatic() {
        long objectId = this.nativeId();
        int flags = PhysicsCollisionObject.getCollisionFlags(objectId);
        boolean result = (flags & 1) != 0;
        return result;
    }

    public long[] listIgnoredIds() {
        long objectId = this.nativeId();
        int numIgnoredObjects = PhysicsCollisionObject.getNumObjectsWithoutCollision(objectId);
        long[] result = new long[numIgnoredObjects];
        for (int listIndex = 0; listIndex < numIgnoredObjects; ++listIndex) {
            long otherId = PhysicsCollisionObject.getObjectWithoutCollision(objectId, listIndex);
            assert (otherId != 0L);
            result[listIndex] = otherId;
        }
        return result;
    }

    public Integer proxyGroup() {
        Integer result = null;
        long objectId = this.nativeId();
        if (PhysicsCollisionObject.hasBroadphaseProxy(objectId)) {
            result = PhysicsCollisionObject.getProxyFilterGroup(objectId);
        }
        return result;
    }

    public Integer proxyMask() {
        Integer result = null;
        long objectId = this.nativeId();
        if (PhysicsCollisionObject.hasBroadphaseProxy(objectId)) {
            result = PhysicsCollisionObject.getProxyFilterMask(objectId);
        }
        return result;
    }

    public void removeCollideWithGroup(int collisionGroup) {
        this.collideWithGroups &= ~collisionGroup;
        if (this.hasAssignedNativeObject()) {
            this.setCollideWithGroups(this.collideWithGroups);
        }
    }

    public void removeFromIgnoreList(PhysicsCollisionObject otherPco) {
        Validate.nonNull(otherPco, "other");
        Validate.require(otherPco != this, "2 distinct collision objects");
        if (this.ignores(otherPco)) {
            long thisId = this.nativeId();
            long otherId = otherPco.nativeId();
            boolean toIgnore = false;
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, toIgnore);
        }
    }

    public void setAnisotropicFriction(Vector3f components, int mode) {
        Validate.nonNull(components, "components");
        Validate.inRange(mode, "mode", 0, 2);
        long objectId = this.nativeId();
        PhysicsCollisionObject.setAnisotropicFriction(objectId, components, mode);
    }

    public void setCcdMotionThreshold(float threshold) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCcdMotionThreshold(objectId, threshold);
    }

    public void setCcdSweptSphereRadius(float radius) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCcdSweptSphereRadius(objectId, radius);
    }

    public void setCollideWithGroups(int collisionGroups) {
        long objectId = this.nativeId();
        this.collideWithGroups = collisionGroups;
        PhysicsCollisionObject.setCollideWithGroups(objectId, this.collideWithGroups);
    }

    public void setCollisionGroup(int collisionGroup) {
        Validate.require(Integer.bitCount(collisionGroup) == 1, "exactly one bit set");
        this.collisionGroup = collisionGroup;
        long objectId = this.nativeId();
        PhysicsCollisionObject.setCollisionGroup(objectId, collisionGroup);
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        Validate.nonNull(collisionShape, "collision shape");
        this.collisionShape = collisionShape;
    }

    public void setContactDamping(float damping) {
        long objectId = this.nativeId();
        float stiffness = PhysicsCollisionObject.getContactStiffness(objectId);
        PhysicsCollisionObject.setContactStiffnessAndDamping(objectId, stiffness, damping);
    }

    public void setContactProcessingThreshold(float distance) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setContactProcessingThreshold(objectId, distance);
    }

    public void setContactStiffness(float stiffness) {
        long objectId = this.nativeId();
        float damping = PhysicsCollisionObject.getContactDamping(objectId);
        PhysicsCollisionObject.setContactStiffnessAndDamping(objectId, stiffness, damping);
    }

    public void setDeactivationTime(float time) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setDeactivationTime(objectId, time);
    }

    public void setFriction(float friction) {
        Validate.nonNegative(friction, "friction");
        long objectId = this.nativeId();
        PhysicsCollisionObject.setFriction(objectId, friction);
    }

    public void setIgnoreList(long[] idList) {
        Validate.nonNull(idList, "ID list");
        this.clearIgnoreList();
        long thisId = this.nativeId();
        for (long otherId : idList) {
            PhysicsCollisionObject.setIgnoreCollisionCheck(thisId, otherId, true);
        }
    }

    public void setRestitution(float restitution) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setRestitution(objectId, restitution);
    }

    public void setRollingFriction(float friction) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setRollingFriction(objectId, friction);
    }

    public void setSpinningFriction(float friction) {
        long objectId = this.nativeId();
        PhysicsCollisionObject.setSpinningFriction(objectId, friction);
    }

    public void setUserObject(Object user) {
        this.userObject = user;
    }

    public long spaceId() {
        long objectId = this.nativeId();
        long spaceId = PhysicsCollisionObject.getSpaceId(objectId);
        return spaceId;
    }

    protected static native void attachCollisionShape(long var0, long var2);

    protected static native void finalizeNative(long var0);

    protected static native int getCollisionFlags(long var0);

    protected static final native int getInternalType(long var0);

    protected void initUserPointer() {
        logger.log(Level.FINE, "initUserPointer() for {0}", this);
        long objectId = this.nativeId();
        this.initUserPointer(objectId, this.collisionGroup, this.collideWithGroups);
        assert (PhysicsCollisionObject.getCollisionGroup(objectId) == this.collisionGroup);
        assert (PhysicsCollisionObject.getCollideWithGroups(objectId) == this.collideWithGroups);
        assert (PhysicsCollisionObject.getSpaceId(objectId) == 0L);
    }

    protected static native void setActivationState(long var0, int var2);

    protected static native void setCollisionFlags(long var0, int var2);

    protected static native void setIgnoreCollisionCheck(long var0, long var2, boolean var4);

    protected void setLocationAndBasis(Vector3f centerLocation, Matrix3f orientation) {
        Validate.finite(centerLocation, "center location");
        Validate.nonNull(orientation, "orientation");
        long objectId = this.nativeId();
        PhysicsCollisionObject.setLocationAndBasis(objectId, centerLocation, orientation);
    }

    @Override
    public String toString() {
        String result = this.getClass().getSimpleName();
        result = result.replace("Body", "");
        result = result.replace("Physics", "");
        result = result.replace("Object", "");
        if (this.hasAssignedNativeObject()) {
            long objectId = this.nativeId();
            result = result + "#" + Long.toHexString(objectId);
        } else {
            result = result + "#unassigned";
        }
        return result;
    }

    private static void freeNativeObject(long objectId) {
        assert (objectId != 0L);
        PhysicsCollisionObject.finalizeNative(objectId);
    }

    private static native void activate(long var0, boolean var2);

    private static native int getActivationState(long var0);

    private static native void getAnisotropicFriction(long var0, Vector3f var2);

    private static native void getBasis(long var0, Matrix3f var2);

    private static native void getBasisDp(long var0, Matrix3d var2);

    private static native float getCcdMotionThreshold(long var0);

    private static native float getCcdSweptSphereRadius(long var0);

    private static native int getCollideWithGroups(long var0);

    private static native int getCollisionGroup(long var0);

    private static native CollisionSpace getCollisionSpace(long var0);

    private static native float getContactDamping(long var0);

    private static native float getContactProcessingThreshold(long var0);

    private static native float getContactStiffness(long var0);

    private static native float getDeactivationTime(long var0);

    private static native float getFriction(long var0);

    private static native void getLocation(long var0, Vector3f var2);

    private static native void getLocationDp(long var0, Vec3d var2);

    private static native int getNumObjectsWithoutCollision(long var0);

    private static native long getObjectWithoutCollision(long var0, int var2);

    private static native void getOrientation(long var0, Quaternion var2);

    private static native void getOrientationDp(long var0, Quatd var2);

    private static native int getProxyFilterGroup(long var0);

    private static native int getProxyFilterMask(long var0);

    private static native float getRestitution(long var0);

    private static native float getRollingFriction(long var0);

    private static native long getSpaceId(long var0);

    private static native float getSpinningFriction(long var0);

    private static native boolean hasAnisotropicFriction(long var0, int var2);

    private static native boolean hasBroadphaseProxy(long var0);

    private native void initUserPointer(long var1, int var3, int var4);

    private static native boolean isActive(long var0);

    private static native boolean isInWorld(long var0);

    private static native void setAnisotropicFriction(long var0, Vector3f var2, int var3);

    private static native void setCcdMotionThreshold(long var0, float var2);

    private static native void setCcdSweptSphereRadius(long var0, float var2);

    private static native void setCollideWithGroups(long var0, int var2);

    private static native void setCollisionGroup(long var0, int var2);

    private static native void setContactProcessingThreshold(long var0, float var2);

    private static native void setContactStiffnessAndDamping(long var0, float var2, float var3);

    private static native void setDeactivationTime(long var0, float var2);

    private static native void setFriction(long var0, float var2);

    private static native void setLocationAndBasis(long var0, Vector3f var2, Matrix3f var3);

    private static native void setRestitution(long var0, float var2);

    private static native void setRollingFriction(long var0, float var2);

    private static native void setSpinningFriction(long var0, float var2);
}

