/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.SoftBodyWorldInfo;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsSoftSpace
extends PhysicsSpace {
    public static final Logger logger2 = Logger.getLogger(PhysicsSoftSpace.class.getName());
    private final Map<Long, PhysicsSoftBody> softBodyMap = new ConcurrentHashMap<Long, PhysicsSoftBody>(64);
    private final SoftBodyWorldInfo worldInfo;

    public PhysicsSoftSpace(PhysicsSpace.BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public PhysicsSoftSpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType) {
        super(worldMin, worldMax, broadphaseType, 1);
        long spaceId = super.nativeId();
        long worldInfoId = PhysicsSoftSpace.getWorldInfo(spaceId);
        this.worldInfo = new SoftBodyWorldInfo(worldInfoId);
        Vector3f gravity = super.getGravity(null);
        this.worldInfo.setGravity(gravity);
    }

    public int countSoftBodies() {
        long spaceId = this.nativeId();
        int count = PhysicsSoftSpace.getNumSoftBodies(spaceId);
        assert (count == this.softBodyMap.size());
        return count;
    }

    public Collection<PhysicsSoftBody> getSoftBodyList() {
        Collection<PhysicsSoftBody> result = this.softBodyMap.values();
        result = Collections.unmodifiableCollection(result);
        return result;
    }

    public static PhysicsSoftSpace getSoftSpace() {
        CollisionSpace result = PhysicsSoftSpace.getCollisionSpace();
        return (PhysicsSoftSpace)result;
    }

    public SoftBodyWorldInfo getWorldInfo() {
        assert (this.worldInfo != null);
        assert (this.worldInfo.nativeId() == PhysicsSoftSpace.getWorldInfo(this.nativeId()));
        return this.worldInfo;
    }

    @Override
    public void addCollisionObject(PhysicsCollisionObject pco) {
        if (pco instanceof PhysicsSoftBody) {
            this.addSoftBody((PhysicsSoftBody)pco);
        } else {
            super.addCollisionObject(pco);
        }
    }

    @Override
    public boolean contains(PhysicsCollisionObject pco) {
        boolean result;
        if (pco instanceof PhysicsSoftBody) {
            long pcoId = pco.nativeId();
            result = this.softBodyMap.containsKey(pcoId);
        } else {
            result = super.contains(pco);
        }
        return result;
    }

    @Override
    public int countJoints() {
        Map<Long, PhysicsJoint> map = this.getJointMap();
        int result = map.size();
        return result;
    }

    @Override
    protected void create() {
        int numSolvers = this.countSolvers();
        assert (numSolvers == 1) : numSolvers;
        int broadphase = this.getBroadphaseType().ordinal();
        Vector3f max = this.getWorldMax(null);
        Vector3f min = this.getWorldMin(null);
        long nativeId = this.createPhysicsSoftSpace(min, max, broadphase, false);
        assert (nativeId != 0L);
        assert (PhysicsSoftSpace.getWorldType(nativeId) == 4) : PhysicsSoftSpace.getWorldType(nativeId);
        this.initThread(nativeId);
        this.initSolverInfo();
        logger2.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (PhysicsSoftBody softBody : this.softBodyMap.values()) {
            this.removeSoftBody(softBody);
        }
    }

    @Override
    public Collection<PhysicsCollisionObject> getPcoList() {
        Collection<PhysicsCollisionObject> result = super.getPcoList();
        result.addAll(this.softBodyMap.values());
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty();
        result = result && this.softBodyMap.isEmpty();
        return result;
    }

    @Override
    public void removeCollisionObject(PhysicsCollisionObject pco) {
        if (pco instanceof PhysicsSoftBody) {
            this.removeSoftBody((PhysicsSoftBody)pco);
        } else {
            super.removeCollisionObject(pco);
        }
    }

    @Override
    public void setGravity(Vector3f gravity) {
        super.setGravity(gravity);
        this.worldInfo.setGravity(gravity);
    }

    private void addSoftBody(PhysicsSoftBody softBody) {
        long softBodyId = softBody.nativeId();
        if (this.softBodyMap.containsKey(softBodyId)) {
            logger2.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{softBody, this});
            return;
        }
        assert (!softBody.isInWorld());
        this.softBodyMap.put(softBodyId, softBody);
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "Adding {0} to {1}.", new Object[]{softBody, this});
        }
        long spaceId = this.nativeId();
        PhysicsSoftSpace.addSoftBody(spaceId, softBodyId);
        if (!softBody.isWorldInfoProtected()) {
            softBody.setWorldInfo(this.getWorldInfo());
        }
    }

    private void removeSoftBody(PhysicsSoftBody softBody) {
        long softBodyId = softBody.nativeId();
        if (!this.softBodyMap.containsKey(softBodyId)) {
            logger2.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{softBody, this});
            return;
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "Removing {0} from {1}.", new Object[]{softBody, this});
        }
        this.softBodyMap.remove(softBodyId);
        long spaceId = this.nativeId();
        PhysicsSoftSpace.removeSoftBody(spaceId, softBodyId);
    }

    private static native void addSoftBody(long var0, long var2);

    private native long createPhysicsSoftSpace(Vector3f var1, Vector3f var2, int var3, boolean var4);

    private static native int getNumSoftBodies(long var0);

    private static native long getWorldInfo(long var0);

    private static native void removeSoftBody(long var0, long var2);
}

