/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.MultiBody;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.SolverType;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.MultiBodyCollider;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class MultiBodySpace
extends PhysicsSpace {
    public static final Logger logger2 = Logger.getLogger(MultiBodySpace.class.getName());
    private final Map<Long, MultiBody> multiBodyMap = new ConcurrentHashMap<Long, MultiBody>(64);

    public MultiBodySpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType) {
        super(worldMin, worldMax, broadphaseType, 1);
    }

    public MultiBodySpace(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType, SolverType solverType) {
        super(worldMin, worldMax, broadphaseType, solverType);
    }

    public void addMultiBody(MultiBody multiBody) {
        long multiBodyId = multiBody.nativeId();
        if (this.multiBodyMap.containsKey(multiBodyId)) {
            logger2.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{multiBody, this});
            return;
        }
        this.multiBodyMap.put(multiBodyId, multiBody);
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "Adding {0} to {1}.", new Object[]{multiBody, this});
        }
        long spaceId = this.nativeId();
        MultiBodySpace.addMultiBody(spaceId, multiBodyId);
    }

    public int countMultiBodies() {
        long spaceId = this.nativeId();
        int count = MultiBodySpace.getNumMultibodies(spaceId);
        assert (count == this.multiBodyMap.size()) : count;
        return count;
    }

    public Collection<MultiBody> getMultiBodyList() {
        Collection<MultiBody> result = this.multiBodyMap.values();
        result = Collections.unmodifiableCollection(result);
        return result;
    }

    public static MultiBodySpace getMultiBodySpace() {
        CollisionSpace result = MultiBodySpace.getCollisionSpace();
        return (MultiBodySpace)result;
    }

    public void removeMultiBody(MultiBody multiBody) {
        long multiBodyId = multiBody.nativeId();
        if (!this.multiBodyMap.containsKey(multiBodyId)) {
            logger2.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{multiBody, this});
            return;
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "Removing {0} from {1}.", new Object[]{multiBody, this});
        }
        this.multiBodyMap.remove(multiBodyId);
        long spaceId = this.nativeId();
        MultiBodySpace.removeMultiBody(spaceId, multiBodyId);
    }

    @Override
    public void activateAll(boolean forceFlag) {
        super.activateAll(forceFlag);
        for (MultiBody multiBody : this.multiBodyMap.values()) {
            List<MultiBodyCollider> colliders = multiBody.listColliders();
            for (MultiBodyCollider collider : colliders) {
                collider.activate(forceFlag);
            }
        }
    }

    @Override
    public void add(Object object) {
        Validate.nonNull(object, "object");
        if (object instanceof MultiBody) {
            this.addMultiBody((MultiBody)object);
        } else {
            super.add(object);
        }
    }

    @Override
    public boolean contains(PhysicsCollisionObject pco) {
        boolean result = false;
        if (pco instanceof MultiBodyCollider) {
            MultiBody multiBody;
            MultiBodyCollider collider = (MultiBodyCollider)pco;
            Iterator<MultiBody> iterator = this.multiBodyMap.values().iterator();
            while (iterator.hasNext() && !(result = (multiBody = iterator.next()).contains(collider))) {
            }
        } else {
            result = super.contains(pco);
        }
        return result;
    }

    @Override
    protected void create() {
        int numSolvers = this.countSolvers();
        assert (numSolvers == 1) : numSolvers;
        int broadphase = this.getBroadphaseType().ordinal();
        Vector3f max = this.getWorldMax(null);
        Vector3f min = this.getWorldMin(null);
        long nativeId = this.createMultiBodySpace(min, max, broadphase);
        assert (nativeId != 0L);
        assert (MultiBodySpace.getWorldType(nativeId) == 2) : MultiBodySpace.getWorldType(nativeId);
        this.initThread(nativeId);
        this.initSolverInfo();
        logger2.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (MultiBody multibody : this.multiBodyMap.values()) {
            this.removeMultiBody(multibody);
        }
    }

    @Override
    public Collection<PhysicsCollisionObject> getPcoList() {
        Collection<PhysicsCollisionObject> result = super.getPcoList();
        for (MultiBody multiBody : this.multiBodyMap.values()) {
            List<MultiBodyCollider> pcos = multiBody.listColliders();
            result.addAll(pcos);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty();
        result = result && this.multiBodyMap.isEmpty();
        return result;
    }

    @Override
    public void remove(Object object) {
        if (object instanceof MultiBody) {
            this.removeMultiBody((MultiBody)object);
        } else {
            super.remove(object);
        }
    }

    @Override
    protected void updateSolver() {
        long spaceId = this.nativeId();
        SolverType type = this.getSolverType();
        int ordinal = type.ordinal();
        MultiBodySpace.setSolverType(spaceId, ordinal);
    }

    private static native void addMultiBody(long var0, long var2);

    private static native void addMultiBodyConstraint(long var0, long var2);

    private native long createMultiBodySpace(Vector3f var1, Vector3f var2, int var3);

    private static native int getNumMultibodies(long var0);

    private static native int getNumMultiBodyConstraints(long var0);

    private static native void removeMultiBody(long var0, long var2);

    private static native void removeMultiBodyConstraint(long var0, long var2);

    private static native void setSolverType(long var0, int var2);
}

