/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.NativePhysicsObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

final class FreeingMethods {
    public static final Logger logger = Logger.getLogger(FreeingMethods.class.getName());
    private static final Map<Class<? extends NativePhysicsObject>, Method[]> map = new ConcurrentHashMap<Class<? extends NativePhysicsObject>, Method[]>(30);

    private FreeingMethods() {
    }

    static Method[] listMethods(Class<? extends NativePhysicsObject> clazz) {
        Method[] result = map.get(clazz);
        if (result == null) {
            result = FreeingMethods.generate(clazz);
            map.put(clazz, result);
        }
        return result;
    }

    private static Method[] generate(Class<? extends NativePhysicsObject> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>(4);
        for (Class<? extends NativePhysicsObject> c = clazz; c != Object.class; c = c.getSuperclass()) {
            try {
                Method method = c.getDeclaredMethod("freeNativeObject", Long.TYPE);
                method.setAccessible(true);
                methods.add(method);
                continue;
            }
            catch (IllegalArgumentException | NoClassDefFoundError | SecurityException exception) {
                System.out.println("c = " + c.getName());
                throw new RuntimeException(exception);
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
        }
        int numMethods = methods.size();
        Method[] result = new Method[numMethods];
        methods.toArray(result);
        return result;
    }
}

