/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bounding;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;

public class BoundingBox {
    private final Vector3f center = new Vector3f();
    float xExtent;
    float yExtent;
    float zExtent;

    public BoundingBox() {
    }

    public BoundingBox(Vector3f c, float x, float y, float z) {
        this.center.set(c);
        this.xExtent = x;
        this.yExtent = y;
        this.zExtent = z;
    }

    public BoundingBox(Vector3f min, Vector3f max) {
        this.setMinMax(min, max);
    }

    public Vector3f getCenter(Vector3f storeResult) {
        if (storeResult == null) {
            return this.center.clone();
        }
        return storeResult.set(this.center);
    }

    public Vector3f getExtent(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        store.set(this.xExtent, this.yExtent, this.zExtent);
        return store;
    }

    public float getXExtent() {
        return this.xExtent;
    }

    public float getYExtent() {
        return this.yExtent;
    }

    public float getZExtent() {
        return this.zExtent;
    }

    public void setXExtent(float xExtent) {
        if (xExtent < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.xExtent = xExtent;
    }

    public void setYExtent(float yExtent) {
        if (yExtent < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.yExtent = yExtent;
    }

    public void setZExtent(float zExtent) {
        if (zExtent < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.zExtent = zExtent;
    }

    public Vector3f getMin(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        store.set(this.center).subtractLocal(this.xExtent, this.yExtent, this.zExtent);
        return store;
    }

    public Vector3f getMax(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        store.set(this.center).addLocal(this.xExtent, this.yExtent, this.zExtent);
        return store;
    }

    public void setMinMax(Vector3f min, Vector3f max) {
        this.center.set(max).addLocal(min).multLocal(0.5f);
        this.xExtent = FastMath.abs(max.x - this.center.x);
        this.yExtent = FastMath.abs(max.y - this.center.y);
        this.zExtent = FastMath.abs(max.z - this.center.z);
    }
}

