/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;

public class AshVentFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_50652_, (Object)Blocks.f_50409_, (Object)Blocks.f_50157_, (Object)Blocks.f_50079_, (Object)Blocks.f_50647_, (Object)Blocks.f_50633_, (Object)Blocks.f_50222_, (Object)Blocks.f_50223_, (Object)Blocks.f_50224_, (Object)Blocks.f_50411_, (Object)Blocks.f_50452_, (Object)Blocks.f_50601_, (Object[])new Block[]{Blocks.f_50640_, Blocks.f_50645_, Blocks.f_50411_, Blocks.f_50353_, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50387_, Blocks.f_50281_, Blocks.f_50175_, Blocks.f_50602_, Blocks.f_50646_, Blocks.f_50643_, Blocks.f_50641_, Blocks.f_50632_, Blocks.f_50629_, Blocks.f_50183_, Blocks.f_50136_, Blocks.f_49994_, Blocks.f_50645_, Blocks.f_49991_, Blocks.f_50752_, Blocks.f_50450_, Blocks.f_50135_, Blocks.f_50197_, Blocks.f_50198_, Blocks.f_50199_, Blocks.f_50200_, Blocks.f_50087_, (Block)RuBlocks.ASH_VENT.get(), (Block)RuBlocks.DEAD_LEAVES.get()});

    public AshVentFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        if (level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            this.placeBlob((LevelAccessor)level, pos);
            return true;
        }
        return false;
    }

    public boolean placeBlob(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        if (pos.m_123342_() <= level.m_141937_() + 3) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int i = random.nextInt(4) + 2;
            int j = random.nextInt(4) + 2;
            int k = random.nextInt(4) + 2;
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-i, -j, -k), (BlockPos)pos.m_7918_(i, j, k))) {
                if (!(blockpos1.m_123331_((Vec3i)pos) <= (double)(f * f)) || !level.m_8055_(blockpos1.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.DOWN) || random.nextInt(5) != 0) continue;
                if (CANNOT_PLACE_ON.contains((Object)level.m_8055_(pos.m_7495_()))) {
                    return true;
                }
                this.placePillar(level, blockpos1);
            }
            pos = pos.m_7918_(-1 + random.nextInt(2), -random.nextInt(2), -1 + random.nextInt(2));
        }
        return true;
    }

    public boolean placePillar(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(6);
        if (level.m_46859_(pos) && (level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.DOWN) || !level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ASH_VENT.get()))) {
            BlockPos.MutableBlockPos placePos = pos.m_122032_();
            int count = 0;
            while (level.m_46859_((BlockPos)placePos)) {
                if (level.m_8055_(placePos.m_7495_()).m_60713_((Block)RuBlocks.ASH_VENT.get())) {
                    return true;
                }
                if (count == size) {
                    return true;
                }
                if (level.m_151570_((BlockPos)placePos)) {
                    return true;
                }
                if (count == size - 1) {
                    if (random.nextInt(6) == 0) {
                        level.m_7731_((BlockPos)placePos, ((Block)RuBlocks.ASH_VENT.get()).m_49966_(), 2);
                    } else {
                        level.m_7731_((BlockPos)placePos, Blocks.f_50137_.m_49966_(), 2);
                    }
                } else {
                    level.m_7731_((BlockPos)placePos, Blocks.f_50137_.m_49966_(), 2);
                }
                placePos.m_122173_(Direction.UP);
                ++count;
            }
            return true;
        }
        return true;
    }
}

