/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.villager.ai.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ShowWorkItem
extends Behavior<Villager> {
    private static final int SHOW_COOLDOWN_MAX = 200;
    private static final int SHOW_COOLDOWN_MIN = 40;
    private static final int LAST_WORKED_TIME_LIMIT = 400;
    private final ItemStack item;
    private long showCooldownTimestamp;

    public ShowWorkItem(ItemStack item, int minDuration, int maxDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26330_, (Object)MemoryStatus.VALUE_PRESENT), minDuration, maxDuration);
        this.item = item;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, @NotNull Villager villager) {
        DeliveryTableBlockEntity deliveryTableBlockEntity;
        BlockEntity blockEntity;
        BlockPos jobSitePos;
        if (level.m_46467_() < this.showCooldownTimestamp) {
            return false;
        }
        Optional jobSiteMemory = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (jobSiteMemory.isPresent() && level.m_46749_(jobSitePos = ((GlobalPos)jobSiteMemory.get()).m_122646_()) && (blockEntity = level.m_7702_(jobSitePos)) instanceof DeliveryTableBlockEntity && !(deliveryTableBlockEntity = (DeliveryTableBlockEntity)blockEntity).getAgreementItem().m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get())) {
            return false;
        }
        Brain brain = villager.m_6274_();
        Optional lastWorkedMemory = brain.m_21952_(MemoryModuleType.f_26330_);
        return lastWorkedMemory.isPresent() && level.m_46467_() - (Long)lastWorkedMemory.get() <= 400L;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull Villager villager, long pGameTime) {
        return this.checkExtraStartConditions(level, villager);
    }

    protected void start(@NotNull ServerLevel level, @NotNull Villager villager, long gameTime) {
        super.m_6735_(level, (LivingEntity)villager, gameTime);
        villager.m_8061_(EquipmentSlot.MAINHAND, this.item);
        villager.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        level.m_6269_(null, (Entity)villager, (SoundEvent)Wares.SoundEvents.VILLAGER_WORK_PACKAGER.get(), SoundSource.NEUTRAL, 0.8f, level.m_213780_().m_188501_() * 0.15f + 1.0f);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull Villager villager, long gameTime) {
        super.m_6732_(level, (LivingEntity)villager, gameTime);
        villager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        villager.m_21409_(EquipmentSlot.MAINHAND, 0.085f);
        level.m_6269_(null, (Entity)villager, (SoundEvent)Wares.SoundEvents.VILLAGER_WORK_PACKAGER.get(), SoundSource.NEUTRAL, 0.8f, level.m_213780_().m_188501_() * 0.15f + 0.75f);
        this.showCooldownTimestamp = gameTime + (long)level.m_213780_().m_216339_(40, 200);
    }
}

