/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TextUtil {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String shortenNumber(long value) {
        if (value == Long.MIN_VALUE) {
            return TextUtil.shortenNumber(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + TextUtil.shortenNumber(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static MutableComponent timeFromTicks(long ticks) {
        long minutes = ticks / 20L / 60L;
        if (minutes >= 60L) {
            int hours = (int)(minutes / 60L);
            return hours >= 24 ? Component.m_237110_((String)"gui.wares.days.short", (Object[])new Object[]{hours / 24}) : Component.m_237110_((String)"gui.wares.hours.short", (Object[])new Object[]{hours});
        }
        return Component.m_237110_((String)"gui.wares.minutes.short", (Object[])new Object[]{minutes < 1L ? "<1" : Long.valueOf(minutes)});
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

