/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.menu;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import io.github.mortuusars.wares.config.Config;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class DeliveryTableMenu
extends AbstractContainerMenu {
    public static final int MANUAL_DELIVERY_BUTTON_ID = 0;
    public final DeliveryTableBlockEntity blockEntity;
    private final ContainerData data;

    public DeliveryTableMenu(int containerId, Inventory playerInventory, final DeliveryTableBlockEntity blockEntity, ContainerData containerData) {
        super((MenuType)Wares.MenuTypes.DELIVERY_TABLE.get(), containerId);
        int column;
        int row;
        this.blockEntity = blockEntity;
        this.data = containerData;
        IItemHandlerModifiable itemHandler = blockEntity.getInventory();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 80, 16){

            public boolean m_8010_(Player playerIn) {
                return super.m_8010_(playerIn) && !blockEntity.isAgreementLocked();
            }
        });
        if (((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue()) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 80, 60));
        }
        int index = 2;
        for (row = 0; row < 2; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, 14 + column * 18, 29 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, 110 + column * 18, 29 + row * 18){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return false;
                    }
                });
            }
        }
        for (int row2 = 0; row2 < 3; ++row2) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, column2 + row2 * 9 + 9, 8 + column2 * 18, 90 + row2 * 18));
            }
        }
        for (index = 0; index < 9; ++index) {
            this.m_38897_(new Slot((Container)playerInventory, index, 8 + index * 18, 148));
        }
        this.m_38884_(this.data);
    }

    public static DeliveryTableMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new DeliveryTableMenu(containerID, playerInventory, DeliveryTableMenu.getBlockEntity(playerInventory, buffer), (ContainerData)new SimpleContainerData(3));
    }

    public float getDeliveryProgress() {
        int progress = this.data.m_6413_(0);
        int duration = this.data.m_6413_(1);
        return progress != 0 && duration != 0 ? (float)progress / (float)duration : 0.0f;
    }

    public boolean canDeliverManually() {
        return this.data.m_6413_(2) == 1;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack clickedStack = slot.m_7993_();
        if (index < 14) {
            if (!this.m_38903_(clickedStack, 14, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (index == 0) {
                this.blockEntity.m_6836_(0, slot.m_7993_());
            }
        } else if (index < this.f_38839_.size() && !this.m_38903_(clickedStack, 0, 14, false)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6366_(@NotNull Player player, int buttonId) {
        if (buttonId == 0) {
            this.blockEntity.startManualDelivery();
            return true;
        }
        return false;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.blockEntity.m_6542_(player);
    }

    private static DeliveryTableBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntityAtPos instanceof DeliveryTableBlockEntity) {
            DeliveryTableBlockEntity blockEntity = (DeliveryTableBlockEntity)blockEntityAtPos;
            return blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntityAtPos));
    }
}

