/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.integration.kubejs;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.latvian.mods.kubejs.event.EventJS;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import io.github.mortuusars.wares.integration.kubejs.WaresJSEvents;
import io.github.mortuusars.wares.integration.kubejs.event.DeliveryEventJS;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class KubeJS {
    private static final Supplier<Boolean> isLoaded = Suppliers.memoize(() -> ModList.get().isLoaded("kubejs"));

    public static boolean isLoaded() {
        return (Boolean)isLoaded.get();
    }

    public static void batchDelivered(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
        if (KubeJS.isLoaded()) {
            Events.batchDelivered(blockEntity, player);
        }
    }

    public static void agreementCompleted(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
        if (KubeJS.isLoaded()) {
            Events.agreementCompleted(blockEntity, player);
        }
    }

    public static void agreementExpired(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
        if (KubeJS.isLoaded()) {
            Events.agreementExpired(blockEntity, player);
        }
    }

    private static class Events {
        private Events() {
        }

        public static void batchDelivered(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
            WaresJSEvents.BATCH_DELIVERED.post((EventJS)new DeliveryEventJS(blockEntity, player));
        }

        public static void agreementCompleted(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
            WaresJSEvents.AGREEMENT_COMPLETED.post((EventJS)new DeliveryEventJS(blockEntity, player));
        }

        public static void agreementExpired(DeliveryTableBlockEntity blockEntity, @Nullable ServerPlayer player) {
            WaresJSEvents.AGREEMENT_EXPIRED.post((EventJS)new DeliveryEventJS(blockEntity, player));
        }
    }
}

