/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.data.agreement.component.SealedRequestedItem;
import io.github.mortuusars.wares.data.agreement.component.SteppedInt;
import io.github.mortuusars.wares.data.agreement.component.TextProvider;
import io.github.mortuusars.wares.data.serialization.ComponentCodec;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record SealedDeliveryAgreement(String id, TextProvider buyerName, TextProvider buyerAddress, TextProvider title, TextProvider message, String seal, Component sealTooltip, Component backsideMessage, Either<ResourceLocation, List<SealedRequestedItem>> requested, Either<ResourceLocation, List<ItemStack>> payment, Either<Integer, SteppedInt> ordered, Either<Integer, SteppedInt> experience, Either<Integer, SteppedInt> deliveryTime, Either<Integer, SteppedInt> expiresInSeconds) {
    public static final Codec<SealedDeliveryAgreement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("id", (Object)"").forGetter(SealedDeliveryAgreement::id), (App)TextProvider.CODEC.optionalFieldOf("buyerName", (Object)TextProvider.EMPTY).forGetter(SealedDeliveryAgreement::buyerName), (App)TextProvider.CODEC.optionalFieldOf("buyerAddress", (Object)TextProvider.EMPTY).forGetter(SealedDeliveryAgreement::buyerAddress), (App)TextProvider.CODEC.optionalFieldOf("title", (Object)TextProvider.EMPTY).forGetter(SealedDeliveryAgreement::title), (App)TextProvider.CODEC.optionalFieldOf("message", (Object)TextProvider.EMPTY).forGetter(SealedDeliveryAgreement::message), (App)Codec.STRING.optionalFieldOf("seal", (Object)"default").forGetter(SealedDeliveryAgreement::seal), (App)ComponentCodec.CODEC.optionalFieldOf("sealTooltip", (Object)Component.m_237119_()).forGetter(SealedDeliveryAgreement::sealTooltip), (App)ComponentCodec.CODEC.optionalFieldOf("backsideMessage", (Object)Component.m_237119_()).forGetter(SealedDeliveryAgreement::backsideMessage), (App)Codec.either((Codec)ResourceLocation.f_135803_, (Codec)Codec.list(SealedRequestedItem.CODEC)).fieldOf("requested").forGetter(SealedDeliveryAgreement::requested), (App)Codec.either((Codec)ResourceLocation.f_135803_, (Codec)Codec.list((Codec)ItemStack.f_41582_)).fieldOf("payment").forGetter(SealedDeliveryAgreement::payment), (App)Codec.either((Codec)Codec.INT, SteppedInt.CODEC).optionalFieldOf("ordered", (Object)Either.left((Object)0)).forGetter(SealedDeliveryAgreement::ordered), (App)Codec.either((Codec)Codec.INT, SteppedInt.CODEC).optionalFieldOf("experience", (Object)Either.left((Object)0)).forGetter(SealedDeliveryAgreement::experience), (App)Codec.either((Codec)Codec.INT, SteppedInt.CODEC).optionalFieldOf("deliveryTime", (Object)Either.left((Object)-1)).forGetter(SealedDeliveryAgreement::deliveryTime), (App)Codec.either((Codec)Codec.INT, SteppedInt.CODEC).optionalFieldOf("expiresInSeconds", (Object)Either.left((Object)-1)).forGetter(SealedDeliveryAgreement::expiresInSeconds)).apply((Applicative)instance, SealedDeliveryAgreement::new));

    public static Optional<SealedDeliveryAgreement> fromItemStack(ItemStack itemStack) {
        @Nullable CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return Optional.empty();
        }
        try {
            DataResult result = CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)compoundTag);
            SealedDeliveryAgreement agreement = (SealedDeliveryAgreement)((Pair)result.getOrThrow(false, arg_0 -> ((Logger)Wares.LOGGER).error(arg_0))).getFirst();
            return Optional.of(agreement);
        }
        catch (Exception e) {
            Wares.LOGGER.error("Failed to decode SealedAgreement from item : '" + String.valueOf(itemStack) + "'.\n" + String.valueOf(e));
            return Optional.empty();
        }
    }

    public boolean toItemStack(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41784_();
            DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
            Tag encodedTag = (Tag)result.getOrThrow(false, arg_0 -> ((Logger)Wares.LOGGER).error(arg_0));
            tag.m_128391_((CompoundTag)encodedTag);
            return true;
        }
        catch (Exception e) {
            Wares.LOGGER.error("Failed to encode SealedAgreement to item :\n" + String.valueOf(e));
            return false;
        }
    }

    public DeliveryAgreement realize(ServerLevel level) {
        RandomSource random = level.m_213780_();
        int quantity = (Integer)this.ordered.map(integer -> integer, steppedInt -> steppedInt.sample(random));
        int expiresIn = (Integer)this.expiresInSeconds.map(integer -> integer, steppedInt -> steppedInt.sample(random));
        long expireTime = expiresIn <= 0 ? -1L : level.m_46467_() + (long)expiresIn * 20L;
        return DeliveryAgreement.builder().id(this.id).buyerName(this.buyerName.get(random)).buyerAddress(this.buyerAddress.get(random)).title(this.title.get(random)).message(this.message.get(random)).seal(this.seal).requested(this.realizeRequested(this.requested, level, 6)).payment(this.realizePayment(this.payment, level, 6)).ordered(quantity).experience((Integer)this.experience.map(integer -> integer, steppedInt -> steppedInt.sample(random))).deliveryTime((Integer)this.deliveryTime.map(integer -> integer, steppedInt -> steppedInt.sample(random))).expireTime(expireTime).build();
    }

    private List<RequestedItem> realizeRequested(Either<ResourceLocation, List<SealedRequestedItem>> requested, ServerLevel level, int maxCount) {
        return (List)requested.map(lootTable -> this.compressAndLimitStacks(this.unpackLootTable((ResourceLocation)lootTable, level), maxCount).stream().map(RequestedItem::new).toList(), sealedItems -> sealedItems.stream().map(SealedDeliveryAgreement.mapSealedItem(level)).toList());
    }

    @NotNull
    private static Function<SealedRequestedItem, RequestedItem> mapSealedItem(ServerLevel level) {
        return sealedItem -> new RequestedItem(sealedItem.getTagOrItem(), (Integer)sealedItem.getCount().map(integer -> integer, steppedInt -> steppedInt.sample(level.m_213780_())), sealedItem.getTag());
    }

    private List<ItemStack> realizePayment(Either<ResourceLocation, List<ItemStack>> payment, ServerLevel level, int maxCount) {
        return this.compressAndLimitStacks((List)payment.map(lootTable -> this.unpackLootTable((ResourceLocation)lootTable, level), stacks -> stacks), maxCount);
    }

    private List<ItemStack> unpackLootTable(ResourceLocation lootTablePath, ServerLevel level) {
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTablePath);
        return lootTable.m_287195_(new LootParams.Builder(level).m_287235_(LootContextParamSets.f_81410_));
    }

    private List<ItemStack> compressAndLimitStacks(List<ItemStack> stacks, int stackLimit) {
        SimpleContainer container = new SimpleContainer(stackLimit);
        for (ItemStack item : stacks) {
            container.m_19173_(item);
        }
        return container.m_19195_();
    }

    public static class Builder {
        private String id = "";
        private TextProvider buyerName = TextProvider.EMPTY;
        private TextProvider buyerAddress = TextProvider.EMPTY;
        private TextProvider title = TextProvider.EMPTY;
        private TextProvider message = TextProvider.EMPTY;
        private String seal = "default";
        private Component sealTooltip = Component.m_237119_();
        private Component backsideMessage = Component.m_237119_();
        private Either<ResourceLocation, List<SealedRequestedItem>> requested = Either.right(Collections.emptyList());
        private Either<ResourceLocation, List<ItemStack>> payment = Either.right(Collections.emptyList());
        private Either<Integer, SteppedInt> ordered = Either.left((Object)0);
        private Either<Integer, SteppedInt> experience = Either.left((Object)0);
        private Either<Integer, SteppedInt> deliveryTime = Either.left((Object)-1);
        private Either<Integer, SteppedInt> expiresInSecond = Either.left((Object)-1);

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder buyerName(TextProvider buyerName) {
            this.buyerName = buyerName;
            return this;
        }

        public Builder buyerAddress(TextProvider buyerAddress) {
            this.buyerAddress = buyerAddress;
            return this;
        }

        public Builder title(TextProvider title) {
            this.title = title;
            return this;
        }

        public Builder message(TextProvider message) {
            this.message = message;
            return this;
        }

        public Builder seal(String seal) {
            this.seal = seal;
            return this;
        }

        public Builder sealTooltip(Component sealTooltip) {
            this.sealTooltip = sealTooltip;
            return this;
        }

        public Builder backsideMessage(Component backsideMessage) {
            this.backsideMessage = backsideMessage;
            return this;
        }

        public Builder requested(ResourceLocation lootTable) {
            this.requested = Either.left((Object)lootTable);
            return this;
        }

        public Builder payment(ResourceLocation lootTable) {
            this.payment = Either.left((Object)lootTable);
            return this;
        }

        public Builder requested(List<SealedRequestedItem> items) {
            this.requested = Either.right(items);
            return this;
        }

        public Builder payment(List<ItemStack> items) {
            this.payment = Either.right(items);
            return this;
        }

        public Builder ordered(int ordered) {
            this.ordered = Either.left((Object)ordered);
            return this;
        }

        public Builder ordered(SteppedInt ordered) {
            this.ordered = Either.right((Object)ordered);
            return this;
        }

        public Builder experience(int experience) {
            this.experience = Either.left((Object)experience);
            return this;
        }

        public Builder experience(SteppedInt experience) {
            this.experience = Either.right((Object)experience);
            return this;
        }

        public Builder deliveryTime(int deliveryTime) {
            this.deliveryTime = Either.left((Object)deliveryTime);
            return this;
        }

        public Builder deliveryTime(SteppedInt deliveryTime) {
            this.deliveryTime = Either.right((Object)deliveryTime);
            return this;
        }

        public Builder expiresInSecond(int expiresInSecond) {
            this.expiresInSecond = Either.left((Object)expiresInSecond);
            return this;
        }

        public Builder expiresInSecond(SteppedInt expiresInSecond) {
            this.expiresInSecond = Either.right((Object)expiresInSecond);
            return this;
        }

        public SealedDeliveryAgreement build() {
            return new SealedDeliveryAgreement(this.id, this.buyerName, this.buyerAddress, this.title, this.message, this.seal, this.sealTooltip, this.backsideMessage, this.requested, this.payment, this.ordered, this.experience, this.deliveryTime, this.expiresInSecond);
        }
    }
}

