/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.agreement.AgreementBuilder;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.data.serialization.ComponentCodec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DeliveryAgreement {
    public static final Codec<DeliveryAgreement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("id", (Object)"").forGetter(DeliveryAgreement::getId), (App)ComponentCodec.CODEC.optionalFieldOf("buyerName", (Object)Component.m_237119_()).forGetter(DeliveryAgreement::getBuyerName), (App)ComponentCodec.CODEC.optionalFieldOf("buyerAddress", (Object)Component.m_237119_()).forGetter(DeliveryAgreement::getBuyerAddress), (App)ComponentCodec.CODEC.optionalFieldOf("title", (Object)Component.m_237119_()).forGetter(DeliveryAgreement::getTitle), (App)ComponentCodec.CODEC.optionalFieldOf("message", (Object)Component.m_237119_()).forGetter(DeliveryAgreement::getMessage), (App)Codec.STRING.optionalFieldOf("seal", (Object)"default").forGetter(DeliveryAgreement::getSeal), (App)Codec.list(RequestedItem.CODEC).fieldOf("requestedItems").forGetter(DeliveryAgreement::getRequested), (App)Codec.list((Codec)ItemStack.f_41582_).fieldOf("paymentItems").forGetter(DeliveryAgreement::getPayment), (App)Codec.INT.optionalFieldOf("ordered", (Object)0).forGetter(DeliveryAgreement::getOrdered), (App)Codec.INT.optionalFieldOf("delivered", (Object)0).forGetter(DeliveryAgreement::getDelivered), (App)Codec.INT.optionalFieldOf("experience", (Object)0).forGetter(DeliveryAgreement::getExperience), (App)Codec.INT.optionalFieldOf("deliveryTime", (Object)0).forGetter(DeliveryAgreement::getDeliveryTime), (App)Codec.LONG.optionalFieldOf("expireTimestamp", (Object)-1L).forGetter(DeliveryAgreement::getExpireTimestamp), (App)Codec.BOOL.optionalFieldOf("isCompleted", (Object)false).forGetter(DeliveryAgreement::getIsCompleted), (App)Codec.BOOL.optionalFieldOf("isExpired", (Object)false).forGetter(DeliveryAgreement::getIsExpired)).apply((Applicative)instance, DeliveryAgreement::new));
    public static final int MAX_REQUESTED_STACKS = 6;
    public static final int MAX_PAYMENT_STACKS = 6;
    public static final DeliveryAgreement EMPTY = new AgreementBuilder().build();
    @NotNull
    private final String id;
    @NotNull
    private final Component buyerName;
    @NotNull
    private final Component buyerAddress;
    @NotNull
    private final Component title;
    @NotNull
    private final Component message;
    @NotNull
    private final String seal;
    private final List<RequestedItem> requested;
    private final List<ItemStack> payment;
    private final int ordered;
    private final int experience;
    private final int deliveryTime;
    private final long expireTimestamp;
    private int delivered;
    private boolean isCompleted;
    private boolean isExpired;

    public DeliveryAgreement(@NotNull String id, @NotNull Component buyerName, @NotNull Component buyerAddress, @NotNull Component title, @NotNull Component message, @NotNull String seal, List<RequestedItem> requestedItems, List<ItemStack> paymentItems, int orderedQuantity, int delivered, int experience, int deliveryTime, long expireTimestamp, boolean isCompleted, boolean isExpired) {
        this.id = id;
        this.buyerName = buyerName;
        this.buyerAddress = buyerAddress;
        this.title = title;
        this.message = message;
        this.seal = seal;
        this.requested = requestedItems;
        this.payment = paymentItems;
        this.ordered = orderedQuantity;
        this.delivered = delivered;
        this.experience = experience;
        this.deliveryTime = deliveryTime;
        this.expireTimestamp = expireTimestamp;
        this.isCompleted = isCompleted;
        this.isExpired = isExpired;
    }

    public static AgreementBuilder builder() {
        return new AgreementBuilder();
    }

    public static Optional<DeliveryAgreement> fromItemStack(ItemStack itemStack) {
        if (itemStack.m_41619_() || itemStack.m_41783_() == null || itemStack.m_41783_().m_128456_()) {
            return Optional.empty();
        }
        try {
            DataResult result = CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)itemStack.m_41783_());
            DeliveryAgreement agreement = (DeliveryAgreement)((Pair)result.getOrThrow(false, arg_0 -> ((Logger)Wares.LOGGER).error(arg_0))).getFirst();
            return Optional.of(agreement);
        }
        catch (Exception e) {
            Wares.LOGGER.error("Failed to decode Agreement from item : '" + String.valueOf(itemStack) + "'.\n" + String.valueOf(e));
            return Optional.empty();
        }
    }

    public boolean toItemStack(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41784_();
            DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
            Tag encodedTag = (Tag)result.getOrThrow(false, arg_0 -> ((Logger)Wares.LOGGER).error(arg_0));
            tag.m_128391_((CompoundTag)encodedTag);
            return true;
        }
        catch (Exception e) {
            Wares.LOGGER.error("Failed to encode Agreement to item :\n" + String.valueOf(e));
            return false;
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Component getBuyerName() {
        return this.buyerName;
    }

    @NotNull
    public Component getBuyerAddress() {
        return this.buyerAddress;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public Component getMessage() {
        return this.message;
    }

    @NotNull
    public String getSeal() {
        return this.seal;
    }

    public List<RequestedItem> getRequested() {
        return this.requested;
    }

    public List<ItemStack> getPayment() {
        return this.payment;
    }

    public int getOrdered() {
        return this.ordered;
    }

    public int getDelivered() {
        return this.delivered;
    }

    public boolean isInfinite() {
        return this.getOrdered() <= 0;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getDeliveryTime() {
        return this.deliveryTime;
    }

    public int getDeliveryTimeOrDefault() {
        return this.deliveryTime > 0 ? this.deliveryTime : (Integer)Config.DEFAULT_DELIVERY_TIME.get();
    }

    public long getExpireTimestamp() {
        return this.expireTimestamp;
    }

    public boolean getIsExpired() {
        return this.isExpired;
    }

    public boolean canExpire() {
        return this.getExpireTimestamp() > -1L;
    }

    public boolean isExpired(long gameTime) {
        if (this.isCompleted()) {
            return false;
        }
        return this.isExpired || this.getExpireTimestamp() >= 0L && this.getExpireTimestamp() <= gameTime;
    }

    protected boolean getIsCompleted() {
        return this.isCompleted;
    }

    public boolean isCompleted() {
        return this.isCompleted || this.getOrdered() > 0 && this.getDelivered() == this.getOrdered();
    }

    public void setDelivered(int delivered) {
        this.delivered = delivered;
    }

    public void addDelivered(int add) {
        if (this.delivered < 0) {
            this.delivered = 0;
        }
        this.delivered += add;
    }

    public void onDeliver() {
        this.addDelivered(1);
        if (this.isCompleted()) {
            this.complete();
        }
    }

    public boolean canDeliver(long gameTime) {
        return (this.getRequested().size() > 0 || this.getPayment().size() > 0) && !this.isCompleted() && !this.isExpired(gameTime);
    }

    public void complete() {
        this.isCompleted = true;
        if (this.getDelivered() < this.getOrdered()) {
            this.delivered = this.getOrdered();
        }
    }

    public void expire() {
        this.isExpired = true;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryAgreement that = (DeliveryAgreement)o;
        return !(this.ordered != that.ordered || this.experience != that.experience || this.deliveryTime != that.deliveryTime || this.expireTimestamp != that.expireTimestamp || this.delivered != that.delivered || this.isCompleted != that.isCompleted || this.isExpired != that.isExpired || !Objects.equals(this.id, that.id) || !Objects.equals(this.buyerName, that.buyerName) || !Objects.equals(this.buyerAddress, that.buyerAddress) || !Objects.equals(this.title, that.title) || !Objects.equals(this.message, that.message) || !Objects.equals(this.seal, that.seal) || !Objects.equals(this.requested, that.requested) && this.requested.size() != that.requested.size() || !Objects.equals(this.payment, that.payment) && this.payment.size() != that.payment.size());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.buyerName, this.buyerAddress, this.title, this.message, this.seal, this.requested, this.payment, this.ordered, this.experience, this.deliveryTime, this.expireTimestamp, this.delivered, this.isCompleted, this.isExpired);
    }

    public String toString() {
        return "Agreement{id='" + this.id + "', buyerName=" + String.valueOf(this.buyerName) + ", buyerAddress=" + String.valueOf(this.buyerAddress) + ", title=" + String.valueOf(this.title) + ", message=" + String.valueOf(this.message) + ", seal='" + this.seal + "', requested=" + String.valueOf(this.requested) + ", payment=" + String.valueOf(this.payment) + ", ordered=" + this.ordered + ", experience=" + this.experience + ", deliveryTime=" + this.deliveryTime + ", expireTimestamp=" + this.expireTimestamp + ", delivered=" + this.delivered + ", isCompleted=" + this.isCompleted + ", isExpired=" + this.isExpired + "}";
    }
}

