/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block.entity;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.Package;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PackageBlockEntity
extends BlockEntity {
    private Package pack;
    private boolean unpacksWhenBroken = true;

    public PackageBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Wares.BlockEntities.PACKAGE.get(), pos, blockState);
    }

    public Package getPackage() {
        return this.pack;
    }

    public void setPackage(Package pack) {
        this.pack = pack;
        this.m_6596_();
    }

    public boolean unpacksWhenBroken() {
        return this.unpacksWhenBroken;
    }

    public void setUnpacksWhenBroken(boolean unpackWhenBroken) {
        this.unpacksWhenBroken = unpackWhenBroken;
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.pack = Package.fromTag(tag).orElse(Package.DEFAULT);
        this.unpacksWhenBroken = tag.m_128441_("unpacksWhenBroken") ? tag.m_128471_("unpacksWhenBroken") : true;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.pack != null) {
            this.pack.toTag(tag);
        } else {
            Wares.LOGGER.error("Failed to save package. null.");
        }
        tag.m_128379_("unpacksWhenBroken", this.unpacksWhenBroken);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }
}

