/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import io.github.mortuusars.wares.client.gui.agreement.AgreementGUI;
import io.github.mortuusars.wares.data.agreement.AgreementType;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.item.DeliveryAgreementItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AgreementType> AGREEMENT = EnumProperty.m_61587_((String)"agreement", AgreementType.class);
    private static final VoxelShape TABLE_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0)});
    private static final VoxelShape TABLE_WITH_AGREEMENT_SHAPE = Shapes.m_83110_((VoxelShape)TABLE_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)16.0, (double)2.0, (double)14.0, (double)17.0, (double)14.0));

    public DeliveryTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(AGREEMENT, (Comparable)((Object)AgreementType.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AGREEMENT});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(AGREEMENT) == AgreementType.NONE ? TABLE_SHAPE : TABLE_WITH_AGREEMENT_SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new DeliveryTableBlockEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.f_46443_ ? DeliveryTableBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)Wares.BlockEntities.DELIVERY_TABLE.get()), (lv, pos, st, blockEntity) -> blockEntity.serverTick()) : null;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stackInHand;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof DeliveryTableBlockEntity)) {
            return InteractionResult.FAIL;
        }
        DeliveryTableBlockEntity deliveryTableBlockEntity = (DeliveryTableBlockEntity)blockEntity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            deliveryTableBlockEntity.trySetOwner(serverPlayer);
            player.m_36220_(Wares.Stats.INTERACT_WITH_DELIVERY_TABLE);
        }
        if ((stackInHand = player.m_21120_(hand)).m_41720_() instanceof DeliveryAgreementItem && hitResult.m_82434_() == Direction.UP && deliveryTableBlockEntity.getAgreementItem().m_41619_()) {
            deliveryTableBlockEntity.setAgreementItem(stackInHand.m_41620_(1));
            level.m_6263_(player, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        ItemStack agreementStack = deliveryTableBlockEntity.getAgreementItem();
        if (!agreementStack.m_41619_() && hitResult.m_82450_().f_82480_ > (double)(pos.m_123342_() + 1)) {
            if (player.m_36341_()) {
                if (!level.f_46443_) {
                    if (deliveryTableBlockEntity.isAgreementLocked()) {
                        player.m_5661_((Component)Component.m_237115_((String)"block.wares.delivery_table.agreement_locked"), true);
                        return InteractionResult.SUCCESS;
                    }
                    agreementStack = deliveryTableBlockEntity.extractAgreementItem();
                    ItemEntity item = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, agreementStack);
                    Vec3 delta = Vec3.m_82512_((Vec3i)pos).m_165921_(player.m_20182_(), 0.05).m_82546_(Vec3.m_82512_((Vec3i)pos));
                    item.m_20334_(delta.f_82479_, delta.f_82480_ + 0.25, delta.f_82481_);
                    level.m_7967_((Entity)item);
                    level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 1.1f);
                }
                return InteractionResult.SUCCESS;
            }
            if (deliveryTableBlockEntity.getAgreement() != DeliveryAgreement.EMPTY) {
                if (level.f_46443_) {
                    AgreementGUI.showAsOverlay(player, deliveryTableBlockEntity::getAgreement);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            deliveryTableBlockEntity.trySetOwner(serverPlayer);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)deliveryTableBlockEntity, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof DeliveryTableBlockEntity) {
                DeliveryTableBlockEntity blockEntity2 = (DeliveryTableBlockEntity)blockEntity;
                NonNullList items = NonNullList.m_122780_((int)blockEntity2.m_6643_(), (Object)ItemStack.f_41583_);
                for (int slot = 0; slot < blockEntity2.m_6643_(); ++slot) {
                    if (slot == 0 && blockEntity2.shouldVoidAgreementOnBreak()) continue;
                    items.set(slot, (Object)blockEntity2.m_8020_(slot));
                }
                Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)items);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof DeliveryTableBlockEntity)) {
            return;
        }
        DeliveryTableBlockEntity deliveryTableBlockEntity = (DeliveryTableBlockEntity)blockEntity;
        if (stack.m_41788_()) {
            deliveryTableBlockEntity.m_58638_(stack.m_41786_());
        }
        deliveryTableBlockEntity.onPlacedBy(placer, stack);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof DeliveryTableBlockEntity)) {
            return 0;
        }
        DeliveryTableBlockEntity deliveryTableEntity = (DeliveryTableBlockEntity)blockEntity;
        DeliveryAgreement agreement = deliveryTableEntity.getAgreement();
        if (agreement == DeliveryAgreement.EMPTY || agreement.isExpired(level.m_46467_())) {
            return 0;
        }
        if (agreement.isCompleted()) {
            return 15;
        }
        if (!agreement.isInfinite()) {
            float completion = Mth.m_14036_((float)((float)agreement.getDelivered() / (float)agreement.getOrdered()), (float)0.0f, (float)1.0f);
            return (int)Mth.m_184637_((float)completion, (float)0.0f, (float)1.0f, (float)1.0f, (float)15.0f);
        }
        return 1;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

