/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final IntegerProperty BOXES = IntegerProperty.m_61631_((String)"boxes", (int)1, (int)4);
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public CardboardBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)BOXES, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, BOXES});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPES[(Integer)state.m_61143_((Property)BOXES) - 1 + (state.m_61143_(AXIS) == Direction.Axis.Z ? 4 : 0)];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61122_((Property)BOXES);
        }
        return (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_());
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)BOXES) < 4 ? true : super.m_6864_(state, context);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.m_36341_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int packages = (Integer)blockState.m_61143_((Property)BOXES) - 1;
            if (packages <= 0) {
                level.m_7471_(pos, false);
            } else {
                level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)BOXES, (Comparable)Integer.valueOf(packages)), 3);
            }
            level.m_5594_(null, pos, (SoundEvent)Wares.SoundEvents.CARDBOARD_HIT.get(), SoundSource.BLOCKS, 0.9f, level.m_213780_().m_188501_() * 0.1f + 0.95f);
            player.m_36356_(new ItemStack((ItemLike)this.m_5456_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }

    static {
        CardboardBoxBlock.SHAPES[0] = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)10.0, (double)6.0, (double)13.0);
        CardboardBoxBlock.SHAPES[1] = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)7.0, (double)6.0, (double)13.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)12.0));
        CardboardBoxBlock.SHAPES[2] = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)8.0, (double)6.0, (double)14.0), Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)6.0, (double)15.0)});
        CardboardBoxBlock.SHAPES[3] = Shapes.m_83110_((VoxelShape)SHAPES[2], (VoxelShape)Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)12.0, (double)12.0));
        CardboardBoxBlock.SHAPES[4] = VoxelShapeUtils.rotate(SHAPES[0], Rotation.CLOCKWISE_90);
        CardboardBoxBlock.SHAPES[5] = VoxelShapeUtils.rotate(SHAPES[1], Rotation.CLOCKWISE_90);
        CardboardBoxBlock.SHAPES[6] = VoxelShapeUtils.rotate(SHAPES[2], Rotation.CLOCKWISE_90);
        CardboardBoxBlock.SHAPES[7] = VoxelShapeUtils.rotate(SHAPES[3], Rotation.CLOCKWISE_90);
    }
}

