/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import io.wispforest.accessories.api.slot.SlotType;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class WrappedSlotType
implements ISlotType {
    private final SlotType slotType;

    public WrappedSlotType(SlotType slotType) {
        this.slotType = slotType;
        if (slotType == null) {
            throw new IllegalStateException("Found null SlotType for curios WrappedSlotType!");
        }
    }

    public final SlotType innerSlotType() {
        return this.slotType;
    }

    @Override
    public String getIdentifier() {
        return CuriosWrappingUtils.accessoriesToCurios(this.slotType.name());
    }

    @Override
    public ResourceLocation getIcon() {
        return this.slotType.icon();
    }

    @Override
    public int getOrder() {
        return this.slotType.order();
    }

    @Override
    public int getSize() {
        return this.slotType.amount();
    }

    @Override
    public boolean useNativeGui() {
        return false;
    }

    @Override
    public boolean hasCosmetic() {
        return true;
    }

    @Override
    public boolean canToggleRendering() {
        return true;
    }

    @Override
    public ICurio.DropRule getDropRule() {
        return CuriosWrappingUtils.convert(this.slotType.dropRule());
    }

    @Override
    public Set<ResourceLocation> getValidators() {
        return this.slotType.validators();
    }

    @Override
    public int compareTo(@NotNull ISlotType otherType) {
        if (this.getOrder() == otherType.getOrder()) {
            return this.getIdentifier().compareTo(otherType.getIdentifier());
        }
        if (this.getOrder() > otherType.getOrder()) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        return this.slotType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WrappedSlotType) {
            WrappedSlotType wrappedSlotType = (WrappedSlotType)obj;
            obj = wrappedSlotType.slotType;
        }
        return this.slotType.equals(obj);
    }
}

