/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import com.google.common.collect.HashMultimap;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class WrappedCurio
implements Accessory,
LootingAdjustment,
FortuneAdjustment,
AllowWalkingOnSnow,
EndermanMasked,
PiglinNeutralInducer {
    private final ICurioItem iCurioItem;

    public WrappedCurio(ICurioItem iCurioItem) {
        this.iCurioItem = iCurioItem;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurioItem.curioTick(context, stack);
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurioItem.onEquip(context, ItemStack.f_41583_, stack);
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurioItem.onUnequip(context, ItemStack.f_41583_, stack);
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.canEquip(context, stack);
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.canUnequip(context, stack);
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        super.getDynamicModifiers(stack, reference, builder);
        Pair data = AttributeUtils.getModifierData((ResourceLocation)Accessories.of((String)AccessoryAttributeBuilder.createSlotPath((SlotReference)reference)));
        HashMultimap attributes = HashMultimap.create();
        attributes.putAll(this.iCurioItem.getAttributeModifiers(context, (UUID)data.right(), stack));
        attributes.forEach((attribute, modifier) -> builder.addModifier(attribute, modifier, reference, s -> new ResourceLocation("curios", s)));
    }

    public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return CuriosWrappingUtils.convert(this.iCurioItem.getDropRule(context, source, 0, true, stack));
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurioItem.onEquipFromUse(context, stack);
    }

    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        ICurio.SoundInfo info = this.iCurioItem.getEquipSound(context, stack);
        return new SoundEventData(info.soundEvent(), info.volume(), info.pitch());
    }

    public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.iCurioItem.canEquipFromUse(null, stack);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void onBreak(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurioItem.curioBreak(context, stack);
    }

    public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, TooltipFlag tooltipType) {
        ArrayList<Component> copyData = new ArrayList<Component>(tooltips);
        List<Component> data = this.iCurioItem.getAttributesTooltip(copyData, stack);
        tooltips.clear();
        tooltips.addAll(data);
    }

    public void getExtraTooltip(ItemStack stack, List<Component> tooltips, TooltipFlag tooltipType) {
        ArrayList<Component> components = new ArrayList<Component>();
        List<Component> data = this.iCurioItem.getSlotsTooltip(components, stack);
        tooltips.addAll(data);
    }

    public int getLootingAdjustment(ItemStack stack, SlotReference reference, LivingEntity target, DamageSource damageSource, int currentLevel) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.getLootingLevel(context, damageSource, target, currentLevel, stack);
    }

    public int getFortuneAdjustment(ItemStack stack, SlotReference reference, LootContext context, int currentLevel) {
        SlotContext slotContext = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.getFortuneLevel(slotContext, context, stack);
    }

    public TriState makePiglinsNeutral(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.makesPiglinsNeutral(context, stack) ? TriState.TRUE : TriState.DEFAULT;
    }

    public TriState allowWalkingOnSnow(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.canWalkOnPowderedSnow(context, stack) ? TriState.TRUE : TriState.DEFAULT;
    }

    public TriState isEndermanMasked(EnderMan enderMan, ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurioItem.isEnderMask(context, enderMan, stack) ? TriState.TRUE : TriState.DEFAULT;
    }
}

