/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.api.type.util.IIconHelper;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import top.theillusivec4.curios.mixin.CuriosImplMixinHooks;

public final class CuriosApi {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "curios";
    private static IIconHelper iconHelper;
    private static ICuriosHelper curiosHelper;
    private static ISlotHelper slotHelper;

    public static void registerCurio(Item item, ICurioItem curio) {
        CuriosImplMixinHooks.registerCurio(item, curio);
    }

    public static Optional<ISlotType> getSlot(String id, Level level) {
        return CuriosApi.getSlot(id, level.m_5776_());
    }

    public static Optional<ISlotType> getSlot(String id, boolean isClient) {
        return Optional.ofNullable(CuriosApi.getSlots(isClient).get(id));
    }

    public static Map<String, ISlotType> getSlots(Level level) {
        return CuriosApi.getSlots(level.m_5776_());
    }

    public static Map<String, ISlotType> getSlots(boolean isClient) {
        return CuriosImplMixinHooks.getSlots(isClient);
    }

    public static Map<String, ISlotType> getPlayerSlots(Level level) {
        return CuriosApi.getPlayerSlots(level.m_5776_());
    }

    public static Map<String, ISlotType> getPlayerSlots(boolean isClient) {
        return CuriosApi.getEntitySlots(EntityType.f_20532_, isClient);
    }

    public static Map<String, ISlotType> getEntitySlots(LivingEntity livingEntity) {
        return CuriosApi.getEntitySlots(livingEntity.m_6095_(), livingEntity.m_9236_());
    }

    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type, Level level) {
        return CuriosApi.getEntitySlots(type, level.m_5776_());
    }

    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type, boolean isClient) {
        return CuriosImplMixinHooks.getEntitySlots(type, isClient);
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, Level level) {
        return CuriosApi.getItemStackSlots(stack, level.m_5776_());
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, boolean isClient) {
        return CuriosImplMixinHooks.getItemStackSlots(stack, isClient);
    }

    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack, LivingEntity livingEntity) {
        return CuriosImplMixinHooks.getItemStackSlots(stack, livingEntity);
    }

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        return CuriosImplMixinHooks.getCurio(stack);
    }

    @Nonnull
    public static ICapabilityProvider createCurioProvider(ICurio curio) {
        return CurioItemCapability.createProvider(curio);
    }

    public static LazyOptional<ICuriosItemHandler> getCuriosInventory(LivingEntity livingEntity) {
        return CuriosImplMixinHooks.getCuriosInventory(livingEntity);
    }

    public static boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        return CuriosImplMixinHooks.isStackValid(slotContext, stack);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        return CuriosImplMixinHooks.getAttributeModifiers(slotContext, uuid, stack);
    }

    public static void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        CuriosImplMixinHooks.addSlotModifier(map, identifier, uuid, amount, operation);
    }

    public static void addSlotModifier(ItemStack stack, String identifier, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CuriosImplMixinHooks.addSlotModifier(stack, identifier, name, uuid, amount, operation, slot);
    }

    public static void addModifier(ItemStack stack, Attribute attribute, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CuriosImplMixinHooks.addModifier(stack, attribute, name, uuid, amount, operation, slot);
    }

    public static void registerCurioPredicate(ResourceLocation resourceLocation, Predicate<SlotResult> predicate) {
        CuriosImplMixinHooks.registerCurioPredicate(resourceLocation, predicate);
    }

    public static Optional<Predicate<SlotResult>> getCurioPredicate(ResourceLocation resourceLocation) {
        return CuriosImplMixinHooks.getCurioPredicate(resourceLocation);
    }

    public static Map<ResourceLocation, Predicate<SlotResult>> getCurioPredicates() {
        return CuriosImplMixinHooks.getCurioPredicates();
    }

    public static boolean testCurioPredicates(Set<ResourceLocation> predicates, SlotResult slotResult) {
        return CuriosImplMixinHooks.testCurioPredicates(predicates, slotResult);
    }

    public static UUID getSlotUuid(SlotContext slotContext) {
        return CuriosImplMixinHooks.getUuid(slotContext);
    }

    public static void broadcastCurioBreakEvent(SlotContext slotContext) {
        CuriosImplMixinHooks.broadcastCurioBreakEvent(slotContext);
    }

    static void apiError() {
        LOGGER.error("Missing Curios API implementation!");
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            LOGGER.error(stackTraceElement.toString());
        }
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Optional<ISlotType> getSlot(String id) {
        return CuriosApi.getSlot(id, false);
    }

    @Nonnull
    public static ResourceLocation getSlotIcon(String id) {
        return CuriosApi.getSlot(id, true).map(ISlotType::getIcon).orElse(new ResourceLocation(MODID, "slot/empty_curio_slot"));
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Map<String, ISlotType> getSlots() {
        return CuriosApi.getSlots(false);
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Map<String, ISlotType> getEntitySlots(EntityType<?> type) {
        return CuriosApi.getEntitySlots(type, false);
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Map<String, ISlotType> getPlayerSlots() {
        return CuriosApi.getPlayerSlots(false);
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Map<String, ISlotType> getItemStackSlots(ItemStack stack) {
        return CuriosApi.getItemStackSlots(stack, FMLLoader.getDist() == Dist.CLIENT);
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static void setIconHelper(IIconHelper helper) {
        if (iconHelper == null) {
            iconHelper = helper;
        }
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static IIconHelper getIconHelper() {
        return iconHelper;
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static void setCuriosHelper(ICuriosHelper helper) {
        if (curiosHelper == null) {
            curiosHelper = helper;
        }
    }

    @Deprecated(since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static ICuriosHelper getCuriosHelper() {
        return curiosHelper;
    }

    @Deprecated(forRemoval=true, since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static ISlotHelper getSlotHelper() {
        return slotHelper;
    }

    @Deprecated(forRemoval=true, since="1.20.1")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static void setSlotHelper(ISlotHelper helper) {
        slotHelper = helper;
    }
}

