/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.server;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.client.AMISoundRegistry;
import com.crimsoncrips.alexsmobsinteraction.compat.BOPCompat;
import com.crimsoncrips.alexsmobsinteraction.compat.SoulFiredCompat;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIDamageTypes;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.server.effect.AMIEffects;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockLeafcutterAntChamber;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAlligatorSnappingTurtle;
import com.github.alexthe666.alexsmobs.entity.EntityBananaSlug;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.entity.EntityCombJelly;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityEnderiophage;
import com.github.alexthe666.alexsmobs.entity.EntityFrilledShark;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.entity.EntityMimicube;
import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.entity.EntitySoulVulture;
import com.github.alexthe666.alexsmobs.entity.EntityTusklin;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.EmeraldsForItemsTrade;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alexsmobsinteraction", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AMInteractionEvents {
    @SubscribeEvent
    public void onEntityFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        EntityCrimsonMosquito crimsonMosquito;
        Mob entity = event.getEntity();
        if (entity instanceof EntityCrimsonMosquito && (crimsonMosquito = (EntityCrimsonMosquito)entity).m_217043_().m_188500_() < (Double)AlexsMobsInteraction.COMMON_CONFIG.BLOODED_CHANCE.get()) {
            crimsonMosquito.setBloodLevel(crimsonMosquito.getBloodLevel() + 1);
        }
        if (entity instanceof EntityEnderiophage) {
            EntityEnderiophage enderiophage = (EntityEnderiophage)entity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ENDERIOPHAGE_ADAPTION_ENABLED.get()).booleanValue()) {
                enderiophage.setSkinForDimension();
            }
        }
    }

    @SubscribeEvent
    public void tradeEvents(VillagerTradesEvent villagerTradesEvent) {
        if (villagerTradesEvent.getType() == VillagerProfession.f_35591_ && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.DEVILS_TRADE_ENABLED.get()).booleanValue()) {
            EmeraldsForItemsTrade pupfishTrade = new EmeraldsForItemsTrade((ItemLike)AMItemRegistry.DEVILS_HOLE_PUPFISH_BUCKET.get(), 24, 2, 5);
            List list = (List)villagerTradesEvent.getTrades().get(5);
            list.add(pupfishTrade);
            villagerTradesEvent.getTrades().put(5, (Object)list);
        }
    }

    @SubscribeEvent
    public void mobTickEvents(LivingEvent.LivingTickEvent livingTickEvent) {
        EntityCombJelly entityCombJelly;
        LivingEntity livingEntity = livingTickEvent.getEntity();
        Level level = livingTickEvent.getEntity().m_9236_();
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.BLOODED_EFFECT_ENABLED.get()).booleanValue()) {
            if (ModList.get().isLoaded("biomesoplenty") && livingEntity.m_146900_().m_60713_(BOPCompat.getBOPBlock())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)AMIEffects.BLOODED.get(), 140, 0));
            }
            MobEffectInstance blooded = livingEntity.m_21124_((MobEffect)AMIEffects.BLOODED.get());
            if (livingEntity.m_20071_() && blooded != null) {
                livingEntity.m_21195_((MobEffect)AMIEffects.BLOODED.get());
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)AMIEffects.BLOODED.get(), blooded.m_19557_() - 300, blooded.m_19564_()));
            }
            for (LivingEntity entity : level.m_45976_(LivingEntity.class, livingEntity.m_20191_().m_82400_(1.2))) {
                if (entity == livingEntity || !(livingEntity.m_217043_().m_188500_() < 0.01) || !livingEntity.m_21023_((MobEffect)AMEffectRegistry.EXSANGUINATION.get())) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)AMIEffects.BLOODED.get(), 300, 1));
            }
        }
        if (livingEntity instanceof EntityCombJelly && (entityCombJelly = (EntityCombJelly)livingEntity).m_21223_() < entityCombJelly.m_21233_()) {
            entityCombJelly.m_5634_(0.05f);
        }
        if (livingEntity instanceof EntityCrimsonMosquito) {
            EntityCrimsonMosquito crimsonMosquito = (EntityCrimsonMosquito)livingEntity;
            Entity attach = crimsonMosquito.m_20202_();
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GOOFY_CRIMSON_MULTIPLY_ENABLED.get()).booleanValue() && attach != null && crimsonMosquito.getBloodLevel() > 1 && !(attach instanceof Player) && attach.m_6084_()) {
                ((EntityType)AMEntityRegistry.CRIMSON_MOSQUITO.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)crimsonMosquito.m_20185_(), (double)(crimsonMosquito.m_20186_() + 0.2), (double)crimsonMosquito.m_20189_()), MobSpawnType.MOB_SUMMONED);
                attach.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (livingEntity instanceof EntityGrizzlyBear) {
            EntityGrizzlyBear grizzlyBear = (EntityGrizzlyBear)livingEntity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FREDDYABLE_ENABLED.get()).booleanValue()) {
                String freddy = "Freddy Fazbear";
                if (grizzlyBear.m_7755_().getString().equals(freddy)) {
                    grizzlyBear.setAprilFoolsFlag(2);
                    grizzlyBear.m_7105_(false);
                    grizzlyBear.m_21816_(null);
                }
            }
        }
        if (livingEntity instanceof EntityElephant) {
            EntityElephant elephant = (EntityElephant)livingEntity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ELEPHANT_TRAMPLE_ENABLED.get()).booleanValue()) {
                Iterator var4 = level.m_45976_(LivingEntity.class, elephant.m_20191_().m_82363_(0.25, -2.0, 0.25)).iterator();
                if (elephant.m_20160_() && elephant.m_21824_()) {
                    while (var4.hasNext()) {
                        LivingEntity entity;
                        entity = (LivingEntity)var4.next();
                        if (entity == elephant || entity == elephant.m_6688_() || !(entity.m_20206_() <= 2.0f)) continue;
                        entity.m_6469_(elephant.m_269291_().m_269333_((LivingEntity)elephant), 3.0f);
                        AMIUtils.awardAdvancement(elephant.m_146895_(), "elephant_trample", "trample");
                    }
                }
            }
        }
        if (livingEntity instanceof EntityBananaSlug) {
            EntityBananaSlug bananaSlug = (EntityBananaSlug)livingEntity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GOOFY_BANANA_SLIP_ENABLED.get()).booleanValue()) {
                for (LivingEntity livingEntitys : level.m_45976_(LivingEntity.class, bananaSlug.m_20191_().m_82363_(0.5, 0.2, 0.5))) {
                    Player player;
                    if (!(livingEntitys instanceof Player) || (player = (Player)livingEntitys).m_7500_() || !player.m_6084_()) continue;
                    player.m_6469_(AMIDamageTypes.causeBananaSlip(level.m_9598_()), 100.0f);
                    player.m_216990_((SoundEvent)AMISoundRegistry.BANANA_SLIP.get());
                }
            }
        }
        if (livingEntity instanceof EntityAlligatorSnappingTurtle) {
            EntityAlligatorSnappingTurtle snappingturtle = (EntityAlligatorSnappingTurtle)livingEntity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.MOSS_PROPOGATION_ENABLED.get()).booleanValue() && (level.m_46471_() || level.m_46470_() || snappingturtle.m_20069_()) && snappingturtle.m_217043_().m_188500_() < 1.0E-4) {
                snappingturtle.setMoss(Math.min(10, snappingturtle.getMoss() + 1));
            }
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BlockState feetBlockstate = player.m_20075_();
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.COMBUSTABLE_ENABLED.get()).booleanValue() && player.m_21023_((MobEffect)AMEffectRegistry.OILED.get())) {
                if (feetBlockstate.m_60713_(Blocks.f_50450_) || feetBlockstate.m_60713_(Blocks.f_50683_)) {
                    player.m_20254_(20);
                    AMIUtils.awardAdvancement((Entity)player, "combustable", "combust");
                }
                if (feetBlockstate.m_60713_(Blocks.f_50684_)) {
                    if (ModList.get().isLoaded("soulfired")) {
                        SoulFiredCompat.setOnFire((Entity)player, 20);
                    } else {
                        player.m_20254_(20);
                    }
                    AMIUtils.awardAdvancement((Entity)player, "combustable", "combust");
                }
            }
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GOOFY_BANANA_SLIP_ENABLED.get()).booleanValue() && feetBlockstate.m_60713_((Block)AMBlockRegistry.BANANA_PEEL.get()) && !player.m_7500_() && player.m_6084_()) {
                player.m_6469_(AMIDamageTypes.causeBananaSlip(level.m_9598_()), 100.0f);
                player.m_216990_((SoundEvent)AMISoundRegistry.BANANA_SLIP.get());
            }
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.SUNBIRD_UPGRADE_ENABLED.get()).booleanValue()) {
                for (LivingEntity entity : level.m_45976_(LivingEntity.class, player.m_20191_().m_82377_(7.0, 4.0, 7.0))) {
                    MobType entityType = entity.m_6336_();
                    if (entityType != MobType.f_21641_ || entity.m_20069_()) continue;
                    if (player.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_BLESSING.get())) {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                        entity.m_20254_(3);
                    }
                    if (!player.m_21023_((MobEffect)AMEffectRegistry.SUNBIRD_CURSE.get())) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 350, 2));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 0));
                }
            }
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.TIGER_STEALTH_ENABLED.get()).booleanValue() && player.m_21023_((MobEffect)AMEffectRegistry.TIGERS_BLESSING.get()) && !player.m_20142_() && !player.m_6069_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60, 0, false, false));
            }
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        RandomSource random = player.m_217043_();
        Entity entity = event.getTarget();
        Level level = entity.m_9236_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (itemStack.m_41720_() == AMItemRegistry.LAVA_BOTTLE.get() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.MOLTEN_BATH_ENABLED.get()).booleanValue()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                    player.m_36356_(Items.f_42590_.m_7968_());
                }
                living.m_20254_(10);
                player.m_5496_(SoundEvents.f_12032_, 1.0f, 1.0f);
                player.m_6674_(event.getHand());
                AMIUtils.awardAdvancement((Entity)player, "molten_bath", "molten");
            }
            if (itemStack.m_41720_() == AMItemRegistry.POISON_BOTTLE.get() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.POISONOUS_BATH_ENABLED.get()).booleanValue()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 150, 1));
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                    player.m_36356_(Items.f_42590_.m_7968_());
                }
                player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
                player.m_6674_(event.getHand());
                AMIUtils.awardAdvancement((Entity)player, "poison_bath", "poison");
            }
        }
    }

    @SubscribeEvent
    public void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState = event.getEntity().m_9236_().m_8055_(event.getPos());
        BlockPos pos = event.getPos();
        Level worldIn = event.getLevel();
        RandomSource random = event.getEntity().m_217043_();
        Player livingEntity = event.getEntity();
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.SKREECHER_WARD_ENABLED.get()).booleanValue() && event.getItemStack().m_150930_((Item)AMItemRegistry.SKREECHER_SOUL.get()) && blockState.m_60713_(Blocks.f_220858_) && !((Boolean)blockState.m_61143_((Property)SculkShriekerBlock.f_222154_)).booleanValue()) {
            Player player;
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    BlockPos sculkPos = new BlockPos(pos.m_123341_() + x - 2, pos.m_123342_() - 1, pos.m_123343_() + z - 2);
                    BlockState sculkPosState = worldIn.m_8055_(sculkPos);
                    if (!(random.m_188500_() < 0.7) || !sculkPosState.m_204336_(BlockTags.f_215823_)) continue;
                    worldIn.m_7731_(sculkPos, Blocks.f_220855_.m_49966_(), 2);
                    worldIn.m_186460_(sculkPos, sculkPosState.m_60734_(), 8);
                    worldIn.m_5594_((Player)null, sculkPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + random.m_188501_() * 0.4f);
                    if (random.m_188500_() < 0.2) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235898_, (double)sculkPos.m_123341_() + 0.5, (double)sculkPos.m_123342_() + 1.15, (double)sculkPos.m_123343_() + 0.5, 0.0, 0.05, 0.0);
                    }
                    if (!(random.m_188500_() < 0.2)) continue;
                    for (int i = 0; i < random.m_188503_(5); ++i) {
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235900_, (double)sculkPos.m_123341_() + 0.5, (double)sculkPos.m_123342_() + 1.15, (double)sculkPos.m_123343_() + 0.5, 0.0 + random.m_188583_() * 0.02, 0.01 + random.m_188583_() * 0.02, 0.0 + random.m_188583_() * 0.02);
                    }
                }
            }
            worldIn.m_5594_(null, pos, SoundEvents.f_215750_, SoundSource.AMBIENT, 1.0f, 1.0f);
            worldIn.m_46597_(pos, (BlockState)blockState.m_61124_((Property)SculkShriekerBlock.f_222154_, (Comparable)Boolean.valueOf(true)));
            if (livingEntity instanceof Player && !(player = livingEntity).m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            for (int i = 0; i < 100; ++i) {
                double d0 = random.m_188583_() * 0.02;
                double d1 = random.m_188583_() * 0.02;
                double d2 = random.m_188583_() * 0.02;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d0, d1, d2);
            }
            AMIUtils.awardAdvancement((Entity)livingEntity, "acclamate", "acclamate");
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.COCKROACH_CHAMBER_ENABLED.get()).booleanValue() && blockState.m_60713_((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) && !worldIn.f_46443_ && (Integer)blockState.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) == 5 && livingEntity.m_217043_().m_188500_() < 0.7) {
            Entity entityToSpawn = ((EntityType)AMEntityRegistry.COCKROACH.get()).m_262496_((ServerLevel)worldIn, BlockPos.m_274561_((double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.0), (double)((double)pos.m_123343_() + 0.5)), MobSpawnType.MOB_SUMMONED);
            if (entityToSpawn instanceof EntityCockroach) {
                EntityCockroach cockroach = (EntityCockroach)entityToSpawn;
                if (worldIn.m_213780_().m_188500_() < 0.07) {
                    cockroach.m_6863_(true);
                }
            }
            AMIUtils.awardAdvancement((Entity)livingEntity, "uncover_roach", "uncover");
        }
    }

    @SubscribeEvent
    public void mobDeath(LivingDeathEvent livingDeathEvent) {
        LivingEntity deadEntity = livingDeathEvent.getEntity();
        LivingEntity murdererEntity = deadEntity.m_271686_();
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.SNOW_LUCK_ENABLED.get()).booleanValue() && murdererEntity instanceof EntitySnowLeopard) {
            RandomSource random = murdererEntity.m_217043_();
            if (deadEntity instanceof Goat && random.m_188500_() < 0.5) {
                murdererEntity.m_19998_((ItemLike)Items.f_220219_);
                if (random.m_188500_() < 0.05) {
                    murdererEntity.m_19998_((ItemLike)Items.f_220219_);
                }
            } else if (deadEntity instanceof Turtle && random.m_188500_() < 0.2) {
                murdererEntity.m_19998_((ItemLike)Items.f_42355_);
            } else if (deadEntity instanceof EntityFrilledShark && random.m_188500_() < 0.08) {
                murdererEntity.m_19998_((ItemLike)AMItemRegistry.SERRATED_SHARK_TOOTH.get());
                if (random.m_188500_() < 0.01) {
                    murdererEntity.m_19998_((ItemLike)AMItemRegistry.SERRATED_SHARK_TOOTH.get());
                }
            } else if (deadEntity instanceof EntityBananaSlug && random.m_188500_() < 0.2) {
                murdererEntity.m_19998_((ItemLike)AMItemRegistry.BANANA_SLUG_SLIME.get());
            } else if (deadEntity instanceof Rabbit) {
                murdererEntity.m_19998_((ItemLike)Items.f_42648_);
                if (random.m_188500_() < 0.02) {
                    deadEntity.m_19998_((ItemLike)Items.f_42648_);
                }
            }
        }
    }

    @SubscribeEvent
    public void mobAttack(LivingAttackEvent attackEvent) {
        Entity entity = attackEvent.getSource().m_7640_();
        if (entity instanceof EntitySoulVulture) {
            EntitySoulVulture soulVulture = (EntitySoulVulture)entity;
            soulVulture.setSoulLevel(soulVulture.getSoulLevel() + 1);
        }
    }

    @SubscribeEvent
    public void talkEvent(ServerChatEvent serverChatEvent) {
        ServerPlayer player = serverChatEvent.getPlayer();
        for (EntityMimicube entity : player.m_9236_().m_45976_(EntityMimicube.class, player.m_20191_().m_82400_(9.0))) {
            if (entity == null || !(entity.m_217043_().m_188500_() < 0.8) || entity.m_5448_() != player || !((Boolean)AlexsMobsInteraction.COMMON_CONFIG.MIMICKRY_ENABLED.get()).booleanValue()) continue;
            String message = serverChatEvent.getMessage().getString();
            for (int i = 0; i < 2; ++i) {
                char randomLetter = (char)(97 + player.m_217043_().m_188503_(26));
                message = message.replaceAll(String.valueOf(randomLetter), "\u00a7k" + randomLetter + randomLetter + "\u00a7r");
            }
            AMIUtils.awardAdvancement((Entity)player, "mimickry", "mimic");
            player.m_213846_(Component.m_130674_((String)("<" + player.m_5446_().getString() + "?> " + message)));
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent breakEvent) {
        BlockState blockState = breakEvent.getState();
        Level level = (Level)breakEvent.getLevel();
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.COCKROACH_CHAMBER_ENABLED.get()).booleanValue() && blockState.m_60713_((Block)AMBlockRegistry.LEAFCUTTER_ANT_CHAMBER.get()) && breakEvent.getLevel().m_213780_().m_188500_() < 0.1) {
            if ((Integer)blockState.m_61143_((Property)BlockLeafcutterAntChamber.FUNGUS) < 3) {
                return;
            }
            Entity entityToSpawn = ((EntityType)AMEntityRegistry.COCKROACH.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)((double)breakEvent.getPos().m_123341_() + 0.5), (double)((double)breakEvent.getPos().m_123342_() + 1.0), (double)((double)breakEvent.getPos().m_123343_() + 0.5)), MobSpawnType.MOB_SUMMONED);
            if (entityToSpawn instanceof EntityCockroach) {
                EntityCockroach cockroach = (EntityCockroach)entityToSpawn;
                if (breakEvent.getLevel().m_213780_().m_188500_() < 0.8) {
                    cockroach.m_6863_(true);
                }
            }
            AMIUtils.awardAdvancement((Entity)breakEvent.getPlayer(), "uncover_roach", "uncover");
        }
    }

    @SubscribeEvent
    public void struckLightning(EntityStruckByLightningEvent lightningEvent) {
        Entity entity = lightningEvent.getEntity();
        if (entity instanceof EntityTusklin) {
            EntityTusklin tusklin = (EntityTusklin)entity;
            if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ZOGLINNED_ENABLED.get()).booleanValue()) {
                Level level = tusklin.m_9236_();
                if (!level.f_46443_) {
                    LivingEntity entityToSpawn = (LivingEntity)EntityType.f_20500_.m_262496_((ServerLevel)level, BlockPos.m_274561_((double)(tusklin.m_20185_() + 0.5), (double)(tusklin.m_20186_() + 1.0), (double)(tusklin.m_20189_() + 0.5)), MobSpawnType.TRIGGERED);
                    if (tusklin.m_6162_() && entityToSpawn instanceof Zoglin) {
                        Zoglin zoglin = (Zoglin)entityToSpawn;
                        zoglin.m_6863_(true);
                    }
                    tusklin.m_146870_();
                }
                AMIUtils.awardAdvancement((Entity)lightningEvent.getLightning().m_147158_(), "zoglinned", "zoglinned");
            }
        }
    }

    @SubscribeEvent
    public void mobSpawn(MobSpawnEvent.PositionCheck spawnPlacementCheck) {
        EntityType entityType = spawnPlacementCheck.getEntity().m_6095_();
        Holder biome = spawnPlacementCheck.getLevel().m_204166_(spawnPlacementCheck.getEntity().m_20183_());
        long time = spawnPlacementCheck.getLevel().m_8044_();
        if (entityType == AMEntityRegistry.LOBSTER.get()) {
            if (!((Boolean)AlexsMobsInteraction.COMMON_CONFIG.LOBSTER_NIGHT_ENABLED.get()).booleanValue()) {
                return;
            }
            if (time <= 13000L || time >= 23460L) {
                spawnPlacementCheck.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent livingDamageEvent) {
        Entity damager = livingDamageEvent.getSource().m_7639_();
        LivingEntity damaged = livingDamageEvent.getEntity();
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ACIDIC_LEAFCUTTER_ENABLED.get()).booleanValue() && damager instanceof EntityLeafcutterAnt) {
            EntityLeafcutterAnt leafcutterAnt = (EntityLeafcutterAnt)damager;
            damaged.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100 * (leafcutterAnt.isQueen() ? 4 : 2), leafcutterAnt.isQueen() ? 2 : 0));
        }
    }
}

