/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.cockroach;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.compat.ACCompat;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AsmonRoach;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMIFollowAsmon;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMISurroundEntity;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeHead;
import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCockroach.class})
public abstract class AMICockroach
extends Mob
implements AsmonRoach {
    private int conversionTime;
    private static final EntityDataAccessor<Optional<UUID>> WORSHIPING_UUID = SynchedEntityData.m_135353_(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> IS_GOD = SynchedEntityData.m_135353_(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WORSHIPING_ID = SynchedEntityData.m_135353_(EntityCockroach.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Shadow
    @Final
    protected static EntityDimensions STAND_SIZE;

    @Shadow
    public abstract boolean isDancing();

    @Shadow
    public abstract boolean hasMaracas();

    protected AMICockroach(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"onGetItem"}, at={@At(value="TAIL")}, remap=false)
    private void alexsMobsInteraction$getItem(ItemEntity e, CallbackInfo ci) {
        if (e.m_32055_().m_41614_() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FOOD_TARGET_EFFECTS_ENABLED.get()).booleanValue()) {
            this.m_5634_(5.0f);
            List test = Objects.requireNonNull(e.m_32055_().getFoodProperties((LivingEntity)this)).m_38749_();
            if (!test.isEmpty()) {
                for (int i = 0; i < test.size(); ++i) {
                    this.m_7292_(new MobEffectInstance((MobEffectInstance)((Pair)test.get(i)).getFirst()));
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$tick(CallbackInfo ci) {
        EntityCockroach cockroach = (EntityCockroach)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.COCKROACH_MUTATION_ENABLED.get()).booleanValue() && ModList.get().isLoaded("alexscaves")) {
            if (ACCompat.toxicCaves((LivingEntity)cockroach)) {
                ++this.conversionTime;
            }
            if (this.conversionTime > 360 && !this.m_9236_().f_46443_) {
                ACCompat.gammaroach().m_262496_((ServerLevel)this.m_9236_(), BlockPos.m_274446_((Position)this.m_20318_(1.0f)), MobSpawnType.MOB_SUMMONED);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(WORSHIPING_UUID, Optional.empty());
        this.f_19804_.m_135372_(IS_GOD, (Object)false);
        this.f_19804_.m_135372_(WORSHIPING_ID, (Object)-1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("RoachGod", this.isGod());
        if (this.getWorshipingUUID() != null) {
            compound.m_128362_("WorshipingUUID", this.getWorshipingUUID());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setGod(compound.m_128471_("RoachGod"));
        if (compound.m_128403_("WorshipingUUID")) {
            this.setWorshippingUUID(compound.m_128342_("WorshipingUUID"));
        }
    }

    public UUID getWorshipingUUID() {
        return ((Optional)this.f_19804_.m_135370_(WORSHIPING_UUID)).orElse(null);
    }

    @Override
    @Nullable
    public Entity getWorshiping() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getWorshipingUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(WORSHIPING_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    @Override
    public boolean isGod() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOD);
    }

    @Override
    public void setWorshippingUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(WORSHIPING_UUID, Optional.ofNullable(uniqueId));
    }

    public void setGod(boolean bool) {
        this.f_19804_.m_135381_(IS_GOD, (Object)bool);
        this.m_6210_();
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$registerGoals(CallbackInfo ci) {
        final EntityCockroach cockroach = (EntityCockroach)this;
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)cockroach, 1.1){

            public boolean m_8036_() {
                return super.m_8036_() && !AMICockroach.this.isGod() && AMICockroach.this.getWorshiping() == null;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal<EntityCentipedeHead>((PathfinderMob)cockroach, EntityCentipedeHead.class, 16.0f, 1.3, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !AMICockroach.this.isGod() && AMICockroach.this.getWorshiping() == null;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)cockroach, Player.class, 8.0f, 1.3, 1.0){

            public boolean m_8036_() {
                return !cockroach.isBreaded() && super.m_8036_() && !AMICockroach.this.isGod() && AMICockroach.this.getWorshiping() == null;
            }
        });
        cockroach.f_21345_.m_25352_(8, (Goal)new AMISurroundEntity(cockroach));
        cockroach.f_21345_.m_25352_(9, (Goal)new AMIFollowAsmon(cockroach));
    }

    @Inject(method={"mobInteract"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.m_21120_(hand);
        EntityCockroach cockroach = (EntityCockroach)this;
        if (ModList.get().isLoaded("alexscaves") && itemStack.m_150930_(ACCompat.gameController().m_41720_()) && !this.isDancing() && !this.hasMaracas() && !this.isGod() && this.getWorshiping() == null && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ASMONGOLD_ENABLED.get()).booleanValue()) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                this.setGod(true);
                AMIUtils.awardAdvancement((Entity)player, "asmongold", "asmon");
                cockroach.m_6593_(Component.m_130674_((String)"Asmongold"));
                cockroach.m_21051_(Attributes.f_22284_).m_22100_(10.0);
                cockroach.m_21051_(Attributes.f_22276_).m_22100_(100.0);
                cockroach.m_21051_(Attributes.f_22279_).m_22100_((double)0.1f);
                cockroach.m_21051_(Attributes.f_22278_).m_22100_(3.0);
                cockroach.m_21153_(100.0f);
                cockroach.m_146762_(0);
                cockroach.m_21530_();
                int vasalAmount = 0;
                for (EntityCockroach nearRoaches : cockroach.m_9236_().m_45976_(EntityCockroach.class, this.m_20191_().m_82400_(10.0))) {
                    AsmonRoach myAccessor = (AsmonRoach)nearRoaches;
                    if (nearRoaches == cockroach || myAccessor.isGod() || myAccessor.getWorshiping() != null) continue;
                    myAccessor.setWorshippingUUID(cockroach.m_20148_());
                    nearRoaches.m_6593_(Component.m_130674_((String)"Servant"));
                    ++vasalAmount;
                }
                if (vasalAmount >= 20) {
                    AMIUtils.awardAdvancement((Entity)player, "vassalized", "vassalize");
                }
            }
            player.m_6674_(hand);
        }
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V")})
    private boolean alexsMobsInteraction$registerGoals(GoalSelector instance, int pPriority, Goal pGoal) {
        if (pGoal instanceof PanicGoal || pGoal instanceof AvoidEntityGoal) {
            return (Boolean)AlexsMobsInteraction.COMMON_CONFIG.ORPHANED_ANACONDAS_ENABLED.get() == false;
        }
        return true;
    }

    public boolean m_6573_(Player pPlayer) {
        return super.m_6573_(pPlayer) && !this.isGod() && this.getWorshiping() == null;
    }
}

