/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.datagen.tags.AMIEntityTagGenerator;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.AMIBaseInterfaces;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMIWarnPredator;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRattlesnake;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRattlesnake.class})
public abstract class AMIRattlesnake
extends Animal
implements AMIBaseInterfaces {
    private static final EntityDataAccessor<Boolean> WARDING = SynchedEntityData.m_135353_(EntityRattlesnake.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AMIRattlesnake(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        EntityRattlesnake rattlesnake = (EntityRattlesnake)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.ADD_TARGETS_ENABLED.get()).booleanValue()) {
            rattlesnake.f_21346_.m_25352_(2, (Goal)new EntityAINearestTarget3D<LivingEntity>((Mob)rattlesnake, LivingEntity.class, 300, true, true, AMEntityRegistry.buildPredicateFromTag(AMIEntityTagGenerator.WEAK_PREY)){

                public void m_8056_() {
                    super.m_8056_();
                }
            });
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.RATTLESNAKE_CANNIBALIZE_ENABLED.get()).booleanValue()) {
            rattlesnake.f_21346_.m_25352_(2, (Goal)new EntityAINearestTarget3D((Mob)rattlesnake, EntityRattlesnake.class, 1500, true, true, livingEntity -> livingEntity.m_21223_() <= 0.6f * livingEntity.m_21233_() || livingEntity.m_6162_()));
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.RATTLESNAKE_TERRITORIAL_ENABLED.get()).booleanValue()) {
            rattlesnake.f_21345_.m_25352_(2, (Goal)new AMIWarnPredator(rattlesnake));
            rattlesnake.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)rattlesnake, EntityRattlesnake.class, 5.0f, 1.2, 1.5, livingEntity -> {
                EntityRattlesnake rattle;
                return livingEntity instanceof EntityRattlesnake && ((AMIBaseInterfaces)(rattle = (EntityRattlesnake)livingEntity)).isWarding() && rattle.isRattling();
            }));
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(WARDING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128379_("Warding", this.isWarding());
        super.m_7380_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        this.setWarding(pCompound.m_128471_("Warding"));
        super.m_7378_(pCompound);
    }

    public void setWarding(boolean val) {
        this.f_19804_.m_135381_(WARDING, (Object)val);
    }

    @Override
    public boolean isWarding() {
        return (Boolean)this.f_19804_.m_135370_(WARDING);
    }
}

