/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.datagen.loottables;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class AMILootTables {
    private static final Set<ResourceLocation> AMI_LOOT_TABLES = Sets.newHashSet();
    public static final ResourceLocation FLUTTER_SHEAR = AMILootTables.register("entities/flutter_shear");
    public static final ResourceLocation BANANA_SHEAR = AMILootTables.register("entities/banana_shear");
    public static final ResourceLocation GRIZZLY_BRUSH = AMILootTables.register("entities/grizzly_brush");
    public static final ResourceLocation WITHERED_SKELEWAG = AMILootTables.register("entities/withered_skelewag");
    public static final ResourceLocation SCAVENGE_STRADDLEBOARD = AMILootTables.register("entities/scavenge_straddleboard");
    public static final ResourceLocation OBSIDIAN_EXTRACT = AMILootTables.register("entities/obsidian_extract");
    public final ResourceLocation lootTable;

    private AMILootTables(String path) {
        this.lootTable = AlexsMobsInteraction.prefix(String.format("chests/%s", path));
    }

    private static ResourceLocation register(String id) {
        return AMILootTables.register(AlexsMobsInteraction.prefix(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (AMI_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " loot table already registered");
    }

    public static Set<ResourceLocation> allBuiltin() {
        return Collections.unmodifiableSet(AMI_LOOT_TABLES);
    }
}

