/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.minecraft.client.gui.screens.Screen;

public interface SliderState {
    public double getPos();

    public void setPos(double var1);

    default public double sliderRatio() {
        return 0.1;
    }

    default public double scrollSpeed() {
        double ratio = this.sliderRatio();
        return ratio < 0.1 ? ratio * 0.1 : ratio * ratio;
    }

    default public boolean canScroll(Axis scrollAxis) {
        return true;
    }

    public static SliderState create(final double speed) {
        return new SliderState(){
            double pos = 0.0;

            @Override
            public double getPos() {
                return this.pos;
            }

            @Override
            public void setPos(double pos) {
                this.pos = pos;
            }

            @Override
            public double scrollSpeed() {
                return speed;
            }
        };
    }

    public static SliderState create(final double speed, final Consumer<Double> changeListener) {
        return new SliderState(){
            double pos = 0.0;

            @Override
            public double getPos() {
                return this.pos;
            }

            @Override
            public void setPos(double pos) {
                this.pos = pos;
                changeListener.accept(pos);
            }

            @Override
            public double scrollSpeed() {
                return speed;
            }
        };
    }

    public static SliderState forScrollBar(final Supplier<Double> getPos, final Consumer<Double> setPos, final Supplier<Double> getRatio) {
        return new SliderState(){

            @Override
            public double getPos() {
                return (Double)getPos.get();
            }

            @Override
            public void setPos(double pos) {
                setPos.accept(pos);
            }

            @Override
            public double sliderRatio() {
                return (Double)getRatio.get();
            }

            @Override
            public boolean canScroll(Axis scrollAxis) {
                return scrollAxis == Axis.Y != Screen.m_96638_();
            }
        };
    }

    public static SliderState forSlider(final Supplier<Double> getPos, final Consumer<Double> setPos, final Supplier<Double> getSpeed) {
        return new SliderState(){

            @Override
            public double getPos() {
                return (Double)getPos.get();
            }

            @Override
            public void setPos(double pos) {
                setPos.accept(pos);
            }

            @Override
            public double scrollSpeed() {
                return (Double)getSpeed.get();
            }
        };
    }
}

