/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul.villagers.json;

import com.glisco.numismaticoverhaul.villagers.exceptions.DeserializationException;
import com.glisco.numismaticoverhaul.villagers.json.VillagerTradesHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class VillagerJsonHelper {
    private static final Gson gson = new Gson();

    public static void assertElement(JsonObject object, String key) {
        if (!object.has(key)) {
            throw new DeserializationException("Missing property " + key);
        }
    }

    public static void assertInt(JsonObject object, String key) {
        VillagerJsonHelper.assertElement(object, key);
        if (!object.get(key).isJsonPrimitive()) {
            throw new DeserializationException("Not an integer " + key);
        }
        if (!object.get(key).getAsJsonPrimitive().isNumber()) {
            throw new DeserializationException("Not an integer " + key);
        }
        try {
            Integer.parseInt(object.get(key).getAsString());
        }
        catch (NumberFormatException e) {
            throw new DeserializationException("Not an integer " + key);
        }
    }

    public static void assertString(JsonObject object, String key) {
        VillagerJsonHelper.assertElement(object, key);
        if (!object.get(key).isJsonPrimitive()) {
            throw new DeserializationException("Not a String " + key);
        }
        if (!object.get(key).getAsJsonPrimitive().isString()) {
            throw new DeserializationException("Not a String " + key);
        }
    }

    public static void assertJsonObject(JsonObject object, String key) {
        VillagerJsonHelper.assertElement(object, key);
        if (!object.get(key).isJsonObject()) {
            throw new DeserializationException("Not a JsonObject " + key);
        }
    }

    public static int int_getOrDefault(JsonObject object, String key, int defaultValue) {
        return object.has(key) ? object.get(key).getAsInt() : defaultValue;
    }

    public static float float_getOrDefault(JsonObject object, String key, float defaultValue) {
        return object.has(key) ? object.get(key).getAsFloat() : defaultValue;
    }

    public static boolean boolean_getOrDefault(JsonObject object, String key, boolean defaultValue) {
        return object.has(key) ? object.get(key).getAsBoolean() : defaultValue;
    }

    public static class_1799 ItemStack_getOrDefault(JsonObject object, String key, class_1799 defaultValue) {
        return object.has(key) ? VillagerJsonHelper.getItemStackFromJson(object.get(key).getAsJsonObject()) : defaultValue;
    }

    public static class_1799 getItemStackFromJson(JsonObject json) {
        if (!json.has("item")) {
            throw new DeserializationException("ItemStack missing item ID " + json);
        }
        class_1792 item = VillagerJsonHelper.getItemFromID(json.get("item").getAsString());
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        class_1799 stack = new class_1799((class_1935)item, count);
        if (json.has("tag")) {
            String toParse = json.get("tag").getAsJsonObject().toString();
            class_2487 stackTag = null;
            try {
                stackTag = new class_2522(new StringReader(toParse)).method_10727();
            }
            catch (CommandSyntaxException e) {
                VillagerTradesHandler.addLoadingException(new DeserializationException("Tag parsing error: " + e.getMessage()));
            }
            if (stackTag != null) {
                stack.method_7980(stackTag);
            }
        }
        return stack;
    }

    public static class_1792 getItemFromID(String id) {
        return (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)id)).orElseThrow(() -> new DeserializationException("Invalid item: \"" + id + "\""));
    }

    public static <T> T deepCopy(T object, Class<T> type) {
        try {
            return (T)gson.fromJson(gson.toJson(object, type), type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

