/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BridgeArchProcessor
extends StructureProcessor {
    public static final BridgeArchProcessor INSTANCE = new BridgeArchProcessor();
    public static final Codec<BridgeArchProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_().m_60713_(Blocks.f_50380_) || blockInfoGlobal.f_74676_().m_60713_(Blocks.f_50381_)) {
            Direction facing = structurePlacementData.m_74404_().m_55954_((Direction)blockInfoGlobal.f_74676_().m_61143_((Property)StairBlock.f_56841_));
            boolean isJunction = blockInfoGlobal.f_74676_().m_60713_(Blocks.f_50380_);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), Blocks.f_50197_.m_49966_(), null);
            if (!(levelReader instanceof WorldGenRegion)) {
                return blockInfoGlobal;
            }
            WorldGenRegion worldGenRegion = (WorldGenRegion)levelReader;
            if (levelReader.m_46865_(blockInfoGlobal.f_74675_().m_6630_(3)).m_8055_(blockInfoGlobal.f_74675_().m_6630_(3)).m_60795_()) {
                return blockInfoGlobal;
            }
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.f_74675_().m_122032_();
            mutable.m_122173_(Direction.UP);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.f_50197_.m_49966_());
            mutable.m_122173_(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50610_.m_49966_().m_61124_((Property)WallBlock.f_57950_, (Comparable)(facing == Direction.EAST || isJunction && facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(facing == Direction.SOUTH || isJunction && facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(facing == Direction.WEST || isJunction && facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57951_, (Comparable)(facing == Direction.NORTH || isJunction && facing == Direction.WEST ? WallSide.LOW : WallSide.NONE)));
            mutable.m_122173_(facing);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)Blocks.f_50199_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122424_()));
            mutable.m_122173_(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50610_.m_49966_().m_61124_((Property)WallBlock.f_57950_, (Comparable)(facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(facing == Direction.WEST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57951_, (Comparable)(facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE)));
            mutable.m_122173_(facing);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.f_50197_.m_49966_());
            mutable.m_122173_(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.f_50610_.m_49966_());
            mutable.m_122173_(facing);
            mutable.m_122173_(Direction.DOWN);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50610_.m_49966_().m_61124_((Property)WallBlock.f_57950_, (Comparable)(facing == Direction.WEST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57951_, (Comparable)(facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE)));
            mutable.m_122173_(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)Blocks.f_50199_.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56841_, (Comparable)facing));
            mutable.m_122173_(facing);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50610_.m_49966_().m_61124_((Property)WallBlock.f_57950_, (Comparable)(facing == Direction.WEST || isJunction && facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(facing == Direction.NORTH || isJunction && facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(facing == Direction.EAST || isJunction && facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).m_61124_((Property)WallBlock.f_57951_, (Comparable)(facing == Direction.SOUTH || isJunction && facing == Direction.WEST ? WallSide.LOW : WallSide.NONE)));
            mutable.m_122173_(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.f_50197_.m_49966_());
            mutable.m_122173_(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.f_50197_.m_49966_());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.BRIDGE_ARCH_PROCESSOR;
    }

    private void placeBlock(WorldGenRegion worldGenRegion, LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (worldGenRegion.m_143488_().equals((Object)new ChunkPos(blockPos))) {
            levelReader.m_46865_(blockPos).m_6978_(blockPos, blockState, false);
        }
    }

    private void placeWallBlock(WorldGenRegion worldGenRegion, LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (worldGenRegion.m_143488_().equals((Object)new ChunkPos(blockPos))) {
            BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
            mutable.m_122173_(Direction.NORTH);
            boolean north = levelReader.m_46865_((BlockPos)mutable).m_8055_((BlockPos)mutable).m_60783_((BlockGetter)levelReader, (BlockPos)mutable, Direction.SOUTH);
            mutable.m_122190_((Vec3i)blockPos).m_122173_(Direction.EAST);
            boolean east = levelReader.m_46865_((BlockPos)mutable).m_8055_((BlockPos)mutable).m_60783_((BlockGetter)levelReader, (BlockPos)mutable, Direction.WEST);
            mutable.m_122190_((Vec3i)blockPos).m_122173_(Direction.SOUTH);
            boolean south = levelReader.m_46865_((BlockPos)mutable).m_8055_((BlockPos)mutable).m_60783_((BlockGetter)levelReader, (BlockPos)mutable, Direction.NORTH);
            mutable.m_122190_((Vec3i)blockPos).m_122173_(Direction.WEST);
            boolean west = levelReader.m_46865_((BlockPos)mutable).m_8055_((BlockPos)mutable).m_60783_((BlockGetter)levelReader, (BlockPos)mutable, Direction.EAST);
            levelReader.m_46865_(blockPos).m_6978_(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)WallBlock.f_57951_, (Comparable)(north ? WallSide.LOW : (WallSide)blockState.m_61143_((Property)WallBlock.f_57951_)))).m_61124_((Property)WallBlock.f_57950_, (Comparable)(east ? WallSide.LOW : (WallSide)blockState.m_61143_((Property)WallBlock.f_57950_)))).m_61124_((Property)WallBlock.f_57952_, (Comparable)(south ? WallSide.LOW : (WallSide)blockState.m_61143_((Property)WallBlock.f_57952_)))).m_61124_((Property)WallBlock.f_57953_, (Comparable)(west ? WallSide.LOW : (WallSide)blockState.m_61143_((Property)WallBlock.f_57953_)))).m_61124_((Property)WallBlock.f_57949_, (Comparable)Boolean.valueOf(true)), false);
        }
    }
}

